/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.provision.persist.OnmsMonitoredServiceRequisition;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnmsIpInterfaceRequisition {
    private RequisitionInterface m_iface;
    private final List<OnmsMonitoredServiceRequisition> m_svcReqs;

    public OnmsIpInterfaceRequisition(RequisitionInterface iface) {
        this.m_iface = iface;
        this.m_svcReqs = this.constructSvcReqs();
    }

    RequisitionInterface getInterface() {
        return this.m_iface;
    }

    private List<OnmsMonitoredServiceRequisition> constructSvcReqs() {
        ArrayList<OnmsMonitoredServiceRequisition> reqs = new ArrayList<OnmsMonitoredServiceRequisition>(this.m_iface.getMonitoredServices().size());
        for (RequisitionMonitoredService svc : this.m_iface.getMonitoredServices()) {
            reqs.add(new OnmsMonitoredServiceRequisition(svc));
        }
        return reqs;
    }

    public void visit(RequisitionVisitor visitor) {
        visitor.visitInterface(this);
        for (OnmsMonitoredServiceRequisition svcReq : this.m_svcReqs) {
            svcReq.visit(visitor);
        }
        visitor.completeInterface(this);
    }

    public Object getDescr() {
        return this.m_iface.getDescr();
    }

    public String getIpAddr() {
        return this.m_iface.getIpAddr();
    }

    public boolean getManaged() {
        return this.m_iface.isManaged();
    }

    public String getSnmpPrimary() {
        return this.m_iface.getSnmpPrimary();
    }

    public int getStatus() {
        return this.m_iface.getStatus();
    }
}

