/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.net.URL;
import java.util.Date;
import java.util.Set;
import org.opennms.netmgt.provision.persist.AbstractForeignSourceRepository;
import org.opennms.netmgt.provision.persist.FilesystemForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FusedForeignSourceRepository
extends AbstractForeignSourceRepository
implements ForeignSourceRepository {
    @Autowired
    @Qualifier(value="pending")
    private FilesystemForeignSourceRepository m_pendingForeignSourceRepository;
    @Autowired
    @Qualifier(value="deployed")
    private FilesystemForeignSourceRepository m_deployedForeignSourceRepository;

    @Override
    public Set<String> getActiveForeignSourceNames() {
        Set<String> fsNames = this.m_pendingForeignSourceRepository.getActiveForeignSourceNames();
        fsNames.addAll(this.m_deployedForeignSourceRepository.getActiveForeignSourceNames());
        return fsNames;
    }

    @Override
    public synchronized Requisition importResourceRequisition(Resource resource) throws ForeignSourceRepositoryException {
        Requisition r = this.m_deployedForeignSourceRepository.importResourceRequisition(resource);
        this.updateDeployedForeignSource(r.getForeignSource());
        this.m_pendingForeignSourceRepository.delete(r);
        return r;
    }

    private synchronized void updateDeployedForeignSource(String foreignSourceName) {
        ForeignSource deployed = this.m_deployedForeignSourceRepository.getForeignSource(foreignSourceName);
        ForeignSource pending = this.m_pendingForeignSourceRepository.getForeignSource(foreignSourceName);
        if (pending.isDefault()) {
            this.m_pendingForeignSourceRepository.delete(pending);
        } else if (deployed.isDefault()) {
            this.m_deployedForeignSourceRepository.save(pending);
        } else {
            Date pendingDate = pending.getDateStampAsDate();
            Date deployedDate = deployed.getDateStampAsDate();
            if (!deployedDate.after(pendingDate)) {
                this.m_deployedForeignSourceRepository.save(pending);
            }
        }
        this.m_pendingForeignSourceRepository.delete(pending);
    }

    @Override
    public synchronized void delete(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.m_pendingForeignSourceRepository.delete(foreignSource);
        this.m_deployedForeignSourceRepository.delete(foreignSource);
    }

    @Override
    public synchronized void delete(Requisition requisition) throws ForeignSourceRepositoryException {
        this.m_pendingForeignSourceRepository.delete(requisition);
        this.m_deployedForeignSourceRepository.delete(requisition);
    }

    @Override
    public ForeignSource getForeignSource(String foreignSourceName) throws ForeignSourceRepositoryException {
        return this.m_deployedForeignSourceRepository.getForeignSource(foreignSourceName);
    }

    @Override
    public int getForeignSourceCount() throws ForeignSourceRepositoryException {
        return this.m_deployedForeignSourceRepository.getForeignSourceCount();
    }

    @Override
    public Set<ForeignSource> getForeignSources() throws ForeignSourceRepositoryException {
        return this.m_deployedForeignSourceRepository.getForeignSources();
    }

    @Override
    public Requisition getRequisition(String foreignSourceName) throws ForeignSourceRepositoryException {
        return this.m_deployedForeignSourceRepository.getRequisition(foreignSourceName);
    }

    @Override
    public Requisition getRequisition(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        return this.m_deployedForeignSourceRepository.getRequisition(foreignSource);
    }

    @Override
    public URL getRequisitionURL(String foreignSource) {
        return this.m_deployedForeignSourceRepository.getRequisitionURL(foreignSource);
    }

    @Override
    public Set<Requisition> getRequisitions() throws ForeignSourceRepositoryException {
        return this.m_deployedForeignSourceRepository.getRequisitions();
    }

    @Override
    public synchronized void save(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.m_pendingForeignSourceRepository.delete(foreignSource);
        this.m_deployedForeignSourceRepository.save(foreignSource);
    }

    @Override
    public synchronized void save(Requisition requisition) throws ForeignSourceRepositoryException {
        this.m_pendingForeignSourceRepository.delete(requisition);
        this.m_deployedForeignSourceRepository.save(requisition);
    }
}

