/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.opennms.netmgt.provision.persist.AbstractForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesystemForeignSourceRepository
extends AbstractForeignSourceRepository {
    private String m_requisitionPath;
    private String m_foreignSourcePath;
    private boolean m_updateDateStamps = true;

    @Override
    public Set<String> getActiveForeignSourceNames() {
        TreeSet<String> fsNames = new TreeSet<String>();
        File directory = new File(this.m_foreignSourcePath);
        if (directory.exists()) {
            for (File file : directory.listFiles()) {
                if (!file.getName().endsWith(".xml")) continue;
                fsNames.add(file.getName().replaceAll(".xml$", ""));
            }
        }
        if ((directory = new File(this.m_requisitionPath)).exists()) {
            for (File file : directory.listFiles()) {
                if (!file.getName().endsWith(".xml")) continue;
                fsNames.add(file.getName().replaceAll(".xml$", ""));
            }
        }
        return fsNames;
    }

    public void setUpdateDateStamps(boolean update) {
        this.m_updateDateStamps = update;
    }

    @Override
    public int getForeignSourceCount() throws ForeignSourceRepositoryException {
        return this.getForeignSources().size();
    }

    @Override
    public Set<ForeignSource> getForeignSources() throws ForeignSourceRepositoryException {
        File directory = new File(this.m_foreignSourcePath);
        TreeSet<ForeignSource> foreignSources = new TreeSet<ForeignSource>();
        if (directory.exists()) {
            for (File file : directory.listFiles()) {
                if (!file.getName().endsWith(".xml")) continue;
                foreignSources.add(this.get(file));
            }
        }
        return foreignSources;
    }

    @Override
    public ForeignSource getForeignSource(String foreignSourceName) throws ForeignSourceRepositoryException {
        if (foreignSourceName == null) {
            throw new ForeignSourceRepositoryException("can't get a foreign source with a null name!");
        }
        File inputFile = this.encodeFileName(this.m_foreignSourcePath, foreignSourceName);
        if (inputFile != null && inputFile.exists()) {
            return this.get(inputFile);
        }
        ForeignSource fs = this.getDefaultForeignSource();
        fs.setName(foreignSourceName);
        return fs;
    }

    @Override
    public synchronized void save(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("can't save a null foreign source!");
        }
        if (foreignSource.getName().equals("default")) {
            this.putDefaultForeignSource(foreignSource);
            return;
        }
        File outputFile = this.getOutputFileForForeignSource(foreignSource);
        OutputStreamWriter writer = null;
        try {
            if (this.m_updateDateStamps) {
                foreignSource.updateDateStamp();
            }
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            this.getMarshaller(ForeignSource.class).marshal((Object)foreignSource, (Writer)writer);
        }
        catch (Exception e) {
            try {
                throw new ForeignSourceRepositoryException("unable to write requisition to " + outputFile.getPath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    @Override
    public void delete(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        File deleteFile = this.getOutputFileForForeignSource(foreignSource);
        if (deleteFile.exists() && !deleteFile.delete()) {
            throw new ForeignSourceRepositoryException("unable to delete foreign source file " + deleteFile);
        }
    }

    @Override
    public Set<Requisition> getRequisitions() throws ForeignSourceRepositoryException {
        File directory = new File(this.m_requisitionPath);
        TreeSet<Requisition> requisitions = new TreeSet<Requisition>();
        if (directory.exists()) {
            for (File file : directory.listFiles()) {
                if (!file.getName().endsWith(".xml")) continue;
                try {
                    requisitions.add(this.getRequisition(file));
                }
                catch (ForeignSourceRepositoryException e) {
                    // empty catch block
                }
            }
        }
        return requisitions;
    }

    @Override
    public Requisition getRequisition(String foreignSourceName) throws ForeignSourceRepositoryException {
        if (foreignSourceName == null) {
            throw new ForeignSourceRepositoryException("can't get a requisition with a null foreign source name!");
        }
        File inputFile = this.encodeFileName(this.m_requisitionPath, foreignSourceName);
        if (inputFile != null && inputFile.exists()) {
            return this.getRequisition(inputFile);
        }
        return null;
    }

    @Override
    public Requisition getRequisition(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("can't get a requisition with a null foreign source name!");
        }
        return this.getRequisition(foreignSource.getName());
    }

    @Override
    public synchronized void save(Requisition requisition) throws ForeignSourceRepositoryException {
        if (requisition == null) {
            throw new ForeignSourceRepositoryException("can't save a null requisition!");
        }
        File outputFile = this.getOutputFileForRequisition(requisition);
        OutputStreamWriter writer = null;
        try {
            if (this.m_updateDateStamps) {
                requisition.updateDateStamp();
            }
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            this.getMarshaller(Requisition.class).marshal((Object)requisition, (Writer)writer);
        }
        catch (Exception e) {
            try {
                throw new ForeignSourceRepositoryException("unable to write requisition to " + outputFile.getPath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    @Override
    public void delete(Requisition requisition) throws ForeignSourceRepositoryException {
        if (requisition == null) {
            throw new ForeignSourceRepositoryException("can't delete a null requisition!");
        }
        File deleteFile = this.getOutputFileForRequisition(requisition);
        if (deleteFile.exists() && !deleteFile.delete()) {
            throw new ForeignSourceRepositoryException("unable to delete requisition file " + deleteFile);
        }
    }

    public void setRequisitionPath(String path) {
        this.m_requisitionPath = path;
    }

    public void setForeignSourcePath(String path) {
        this.m_foreignSourcePath = path;
    }

    private synchronized ForeignSource get(File inputFile) throws ForeignSourceRepositoryException {
        try {
            Unmarshaller um = this.getUnmarshaller(ForeignSource.class);
            JAXBElement fs = um.unmarshal((Source)new StreamSource(inputFile), ForeignSource.class);
            return (ForeignSource)fs.getValue();
        }
        catch (JAXBException e) {
            throw new ForeignSourceRepositoryException("unable to unmarshal " + inputFile.getPath(), e);
        }
    }

    private synchronized Requisition getRequisition(File inputFile) throws ForeignSourceRepositoryException {
        try {
            Unmarshaller um = this.getUnmarshaller(Requisition.class);
            JAXBElement req = um.unmarshal((Source)new StreamSource(inputFile), Requisition.class);
            return (Requisition)req.getValue();
        }
        catch (Exception e) {
            throw new ForeignSourceRepositoryException("unable to unmarshal " + inputFile.getPath(), e);
        }
    }

    private void createPath(File fsPath) throws ForeignSourceRepositoryException {
        if (!fsPath.exists() && !fsPath.mkdirs()) {
            throw new ForeignSourceRepositoryException("unable to create directory " + fsPath.getPath());
        }
    }

    private File encodeFileName(String path, String foreignSourceName) {
        return new File(path, foreignSourceName + ".xml");
    }

    private File getOutputFileForForeignSource(ForeignSource foreignSource) {
        File fsPath = new File(this.m_foreignSourcePath);
        this.createPath(fsPath);
        File outputFile = this.encodeFileName(this.m_foreignSourcePath, foreignSource.getName());
        return outputFile;
    }

    private File getOutputFileForRequisition(Requisition requisition) {
        File reqPath = new File(this.m_requisitionPath);
        this.createPath(reqPath);
        File outputFile = this.encodeFileName(this.m_requisitionPath, requisition.getForeignSource());
        return outputFile;
    }

    @Override
    public URL getRequisitionURL(String foreignSource) throws ForeignSourceRepositoryException {
        try {
            return this.getOutputFileForRequisition(this.getRequisition(foreignSource)).toURL();
        }
        catch (MalformedURLException e) {
            throw new ForeignSourceRepositoryException("an error occurred getting the requisition URL", e);
        }
    }

    private Unmarshaller getUnmarshaller(Class<?> objectType) throws JAXBException {
        return this.getJaxbContext(objectType).createUnmarshaller();
    }
}

