/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.ProvisionPrefixContextResolver;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractForeignSourceRepository
implements ForeignSourceRepository {
    private final ProvisionPrefixContextResolver m_jaxbContextResolver;

    public AbstractForeignSourceRepository() {
        try {
            this.m_jaxbContextResolver = new ProvisionPrefixContextResolver();
        }
        catch (JAXBException e) {
            throw new ForeignSourceRepositoryException("unable to get JAXB context resolver", e);
        }
    }

    @Override
    public Requisition importResourceRequisition(Resource resource) throws ForeignSourceRepositoryException {
        Assert.notNull((Object)resource);
        try {
            InputStream resourceStream = resource.getInputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Requisition.class});
            Unmarshaller um = context.createUnmarshaller();
            um.setSchema(null);
            Requisition req = (Requisition)um.unmarshal(resourceStream);
            this.save(req);
            return req;
        }
        catch (Exception e) {
            throw new ForeignSourceRepositoryException("unable to import requisition resource " + resource, e);
        }
    }

    @Override
    public ForeignSource getDefaultForeignSource() throws ForeignSourceRepositoryException {
        ClassPathResource defaultForeignSource = new ClassPathResource("/default-foreign-source.xml");
        if (!defaultForeignSource.exists()) {
            defaultForeignSource = new ClassPathResource("/org/opennms/netmgt/provision/persist/default-foreign-source.xml");
        }
        try {
            InputStream fsStream = defaultForeignSource.getInputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ForeignSource.class});
            Unmarshaller um = context.createUnmarshaller();
            um.setSchema(null);
            ForeignSource fs = (ForeignSource)um.unmarshal(fsStream);
            fs.setDefault(true);
            return fs;
        }
        catch (Exception e) {
            throw new ForeignSourceRepositoryException("unable to access default foreign source resource", e);
        }
    }

    @Override
    public void putDefaultForeignSource(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("foreign source was null");
        }
        foreignSource.setName("default");
        foreignSource.updateDateStamp();
        File outputFile = new File(ConfigFileConstants.getFilePathString() + "default-foreign-source.xml");
        OutputStreamWriter writer = null;
        try {
            foreignSource.updateDateStamp();
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            this.getMarshaller(ForeignSource.class).marshal((Object)foreignSource, (Writer)writer);
        }
        catch (Exception e) {
            try {
                throw new ForeignSourceRepositoryException("unable to write requisition to " + outputFile.getPath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    @Override
    public void resetDefaultForeignSource() throws ForeignSourceRepositoryException {
        File deleteFile = new File(ConfigFileConstants.getFilePathString() + "default-foreign-source.xml");
        if (!deleteFile.exists()) {
            return;
        }
        if (!deleteFile.delete()) {
            this.log().warn("unable to remove " + deleteFile.getPath());
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(AbstractForeignSourceRepository.class);
    }

    @Override
    public OnmsNodeRequisition getNodeRequisition(String foreignSource, String foreignId) throws ForeignSourceRepositoryException {
        Requisition req = this.getRequisition(foreignSource);
        return req == null ? null : req.getNodeRequistion(foreignId);
    }

    protected synchronized Marshaller getMarshaller(Class<?> clazz) throws JAXBException {
        Marshaller marshaller = this.m_jaxbContextResolver.getContext(clazz).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        return marshaller;
    }

    protected JAXBContext getJaxbContext(Class<?> objectType) {
        return this.m_jaxbContextResolver.getContext(objectType);
    }
}

