/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support.jmx.connectors;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.support.jmx.connectors.Jsr160ConnectionWrapper;

public class Jsr160ConnectionFactory {
    static ThreadCategory log = ThreadCategory.getInstance(Jsr160ConnectionFactory.class);

    public static Jsr160ConnectionWrapper getMBeanServerConnection(Map propertiesMap, InetAddress address) {
        String factory = ParameterMap.getKeyedString((Map)propertiesMap, (String)"factory", (String)"STANDARD");
        int port = ParameterMap.getKeyedInteger((Map)propertiesMap, (String)"port", (int)1099);
        String protocol = ParameterMap.getKeyedString((Map)propertiesMap, (String)"protocol", (String)"rmi");
        String urlPath = ParameterMap.getKeyedString((Map)propertiesMap, (String)"urlPath", (String)"/jmxrmi");
        String username = ParameterMap.getKeyedString((Map)propertiesMap, (String)"username", null);
        String password = ParameterMap.getKeyedString((Map)propertiesMap, (String)"password", null);
        return Jsr160ConnectionFactory.getWrapper(address, factory, port, protocol, urlPath, username, password);
    }

    private static Jsr160ConnectionWrapper getWrapper(InetAddress address, String factory, int port, String protocol, String urlPath, String username, String password) {
        Jsr160ConnectionWrapper connectionWrapper = null;
        JMXServiceURL url = null;
        log.debug("JMX: " + factory + " - service:" + protocol + "//" + address.getHostAddress() + ":" + port + urlPath);
        if (factory == null || factory.equals("STANDARD")) {
            try {
                url = new JMXServiceURL("service:jmx:" + protocol + ":///jndi/" + protocol + "://" + address.getHostAddress() + ":" + port + urlPath);
                JMXConnector connector = JMXConnectorFactory.connect(url);
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connectionWrapper = new Jsr160ConnectionWrapper(connector, connection);
            }
            catch (MalformedURLException e) {
                log.warn("URL was malformed: " + url, (Throwable)e);
            }
            catch (IOException e) {
                log.warn("An I/O exception occurred: " + url, (Throwable)e);
            }
        } else if (factory.equals("PASSWORD-CLEAR")) {
            try {
                HashMap<String, String[]> env = new HashMap<String, String[]>();
                String[] credentials = new String[]{username, password};
                env.put("jmx.remote.credentials", credentials);
                url = new JMXServiceURL("service:jmx:" + protocol + ":///jndi/" + protocol + "://" + address.getHostAddress() + ":" + port + urlPath);
                JMXConnector connector = JMXConnectorFactory.newJMXConnector(url, null);
                try {
                    connector.connect(env);
                }
                catch (SecurityException x) {
                    log.error("Security exception: bad credentials");
                    throw x;
                }
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connectionWrapper = new Jsr160ConnectionWrapper(connector, connection);
            }
            catch (Exception e) {
                log.error("Unable to get MBeanServerConnection: " + url, (Throwable)e);
            }
        }
        return connectionWrapper;
    }
}

