/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import java.util.Date;
import org.opennms.protocols.icmp.ICMPHeader;
import org.opennms.protocols.ip.OC16ChecksumProducer;

public final class TimestampReply
extends ICMPHeader {
    private int m_origStamp;
    private int m_recvStamp;
    private int m_xmitStamp;

    public TimestampReply() {
        super((byte)14, (byte)0);
        this.m_recvStamp = this.m_origStamp = (int)(new Date().getTime() & 0xFFFFFFFFFFFFFFFFL);
        this.m_xmitStamp = this.m_origStamp;
    }

    public TimestampReply(byte[] buf, int offset) {
        this.loadFromBuffer(buf, offset);
    }

    public final void computeChecksum() {
        OC16ChecksumProducer summer = new OC16ChecksumProducer();
        super.computeChecksum(summer);
        summer.add(this.m_origStamp);
        summer.add(this.m_recvStamp);
        summer.add(this.m_xmitStamp);
        this.setChecksum(summer.getChecksum());
    }

    public final int storeToBuffer(byte[] buf, int offset) {
        if (buf.length < offset + 20) {
            throw new IndexOutOfBoundsException("Array index overflow in buffer build");
        }
        this.computeChecksum();
        offset = super.storeToBuffer(buf, offset);
        buf[offset++] = (byte)(this.m_origStamp >> 24 & 0xFF);
        buf[offset++] = (byte)(this.m_origStamp >> 16 & 0xFF);
        buf[offset++] = (byte)(this.m_origStamp >> 8 & 0xFF);
        buf[offset++] = (byte)(this.m_origStamp & 0xFF);
        buf[offset++] = (byte)(this.m_recvStamp >> 24 & 0xFF);
        buf[offset++] = (byte)(this.m_recvStamp >> 16 & 0xFF);
        buf[offset++] = (byte)(this.m_recvStamp >> 8 & 0xFF);
        buf[offset++] = (byte)(this.m_recvStamp & 0xFF);
        buf[offset++] = (byte)(this.m_xmitStamp >> 24 & 0xFF);
        buf[offset++] = (byte)(this.m_xmitStamp >> 16 & 0xFF);
        buf[offset++] = (byte)(this.m_xmitStamp >> 8 & 0xFF);
        buf[offset++] = (byte)(this.m_xmitStamp & 0xFF);
        return offset;
    }

    public final int loadFromBuffer(byte[] buf, int offset) {
        if (buf.length < offset + 20) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP header");
        }
        offset = super.loadFromBuffer(buf, offset);
        if (this.getType() != 14) {
            throw new IllegalArgumentException("The buffer did not contain an Timestamp Reply");
        }
        this.m_origStamp = TimestampReply.byteToInt(buf[offset++]) << 24 | TimestampReply.byteToInt(buf[offset++]) << 16 | TimestampReply.byteToInt(buf[offset++]) << 8 | TimestampReply.byteToInt(buf[offset++]);
        this.m_recvStamp = TimestampReply.byteToInt(buf[offset++]) << 24 | TimestampReply.byteToInt(buf[offset++]) << 16 | TimestampReply.byteToInt(buf[offset++]) << 8 | TimestampReply.byteToInt(buf[offset++]);
        this.m_xmitStamp = TimestampReply.byteToInt(buf[offset++]) << 24 | TimestampReply.byteToInt(buf[offset++]) << 16 | TimestampReply.byteToInt(buf[offset++]) << 8 | TimestampReply.byteToInt(buf[offset++]);
        return offset;
    }

    public final void setOriginateTS() {
        this.m_origStamp = (int)(new Date().getTime() & 0xFFFFFFFFFFFFFFFFL);
    }

    public final void setOriginateTS(int ts) {
        this.m_origStamp = ts;
    }

    public final int getOriginateTS() {
        return this.m_origStamp;
    }

    public final void setReceiveTS() {
        this.m_recvStamp = (int)(new Date().getTime() & 0xFFFFFFFFFFFFFFFFL);
    }

    public final void setReceiveTS(int ts) {
        this.m_recvStamp = ts;
    }

    public final int getReceiveTS() {
        return this.m_recvStamp;
    }

    public final void setTransmitTS() {
        this.m_xmitStamp = (int)(new Date().getTime() & 0xFFFFFFFFFFFFFFFFL);
    }

    public final void setTransmitTS(int ts) {
        this.m_xmitStamp = ts;
    }

    public final int getTransmitTS() {
        return this.m_xmitStamp;
    }

    public final byte[] toBytes() {
        byte[] b = new byte[20];
        this.storeToBuffer(b, 0);
        return b;
    }
}

