/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.reporting.service;

import java.io.File;
import javax.mail.MessagingException;
import org.opennms.core.utils.LogUtils;
import org.opennms.javamail.JavaMailerException;
import org.opennms.javamail.JavaSendMailer;
import org.opennms.netmgt.config.reportd.Report;
import org.opennms.netmgt.dao.JavaMailConfigurationDao;
import org.opennms.netmgt.reporting.service.ReportDeliveryService;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;

public class JavaMailDeliveryService
implements ReportDeliveryService {
    JavaMailConfigurationDao m_JavamailConfigDao;

    public void deliverReport(Report report, String fileName) {
        try {
            JavaSendMailer sm = new JavaSendMailer(this.m_JavamailConfigDao.getDefaultSendmailConfig());
            MimeMessageHelper helper = new MimeMessageHelper(sm.getMessage().getMimeMessage(), true);
            for (String recipient : report.getRecipientCollection()) {
                helper.addTo(recipient);
            }
            helper.setSubject("OpenNMS Report: " + report.getReportName());
            helper.setText("OpenNMS Report: ");
            helper.addAttachment(fileName, new File(fileName));
            sm.setMessage(new MimeMailMessage(helper));
            sm.send();
        }
        catch (JavaMailerException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Problem with JavaMailer %s", (Object[])new Object[]{e.getMessage()});
        }
        catch (MessagingException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Problem with Messaging %s", (Object[])new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Unexpected exception: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    public JavaMailConfigurationDao getJavamailConfigDao() {
        return this.m_JavamailConfigDao;
    }

    public void setJavamailConfigDao(JavaMailConfigurationDao javamailConfigDao) {
        this.m_JavamailConfigDao = javamailConfigDao;
    }
}

