/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.reporting.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.reportd.Parameter;
import org.opennms.netmgt.config.reportd.Report;
import org.opennms.netmgt.reporting.service.ReportService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReportService
implements ReportService {
    @Override
    public synchronized String runReport(Report report, String reportDirectory) {
        String outputFile = null;
        try {
            outputFile = this.generateReportName(reportDirectory, report.getReportName(), report.getReportFormat());
            JasperPrint print = this.runAndRender(report);
            outputFile = this.saveReport(print, report.getReportFormat(), outputFile);
        }
        catch (JRException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Error running report: %s", (Object[])new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Unexpected exception: %s", (Object[])new Object[]{e.getMessage()});
        }
        return outputFile;
    }

    private String generateReportName(String reportDirectory, String reportName, String reportFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyyMMddHHmmss");
        return reportDirectory + reportName + sdf.format(new Date()) + "." + reportFormat;
    }

    private String saveReport(JasperPrint jasperPrint, String format, String destFileName) throws JRException, Exception {
        String reportName = null;
        switch (Format.valueOf(format)) {
            case pdf: {
                JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)destFileName);
                reportName = destFileName;
                break;
            }
            case html: {
                JasperExportManager.exportReportToHtmlFile((JasperPrint)jasperPrint, (String)destFileName);
                reportName = this.createZip(destFileName);
                break;
            }
            case xml: {
                JasperExportManager.exportReportToXmlFile((JasperPrint)jasperPrint, (String)destFileName, (boolean)true);
                reportName = this.createZip(destFileName);
                break;
            }
            default: {
                LogUtils.errorf((Object)this, (String)"Error Running Report: Unknown Format: %s", (Object[])new Object[]{format});
            }
        }
        return reportName;
    }

    private JasperPrint runAndRender(Report report) throws Exception, JRException {
        JasperPrint jasperPrint = new JasperPrint();
        JasperReport jasperReport = JasperCompileManager.compileReport((String)(System.getProperty("opennms.home") + "/etc/report-templates/" + report.getReportTemplate()));
        if (report.getReportEngine().equals("jdbc")) {
            Connection connection = DataSourceFactory.getDataSource().getConnection();
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, this.paramListToMap(report.getParameterCollection()), (Connection)connection);
            connection.close();
        } else if (report.getReportEngine().equals("opennms")) {
            LogUtils.errorf((Object)this, (String)"Sorry the OpenNMS Data source engine is not yet available", (Object[])new Object[0]);
            jasperPrint = null;
        } else {
            LogUtils.errorf((Object)this, (String)"Unknown report engine: %s ", (Object[])new Object[]{report.getReportEngine()});
            jasperPrint = null;
        }
        return jasperPrint;
    }

    private String createZip(String baseFileName) {
        File reportResourceDirectory = new File(baseFileName + "_files");
        String zipFile = baseFileName + ".zip";
        if (reportResourceDirectory.exists() && reportResourceDirectory.isDirectory()) {
            try {
                ZipOutputStream reportArchive = new ZipOutputStream(new FileOutputStream(zipFile));
                this.addFileToArchive(reportArchive, baseFileName);
                reportArchive.putNextEntry(new ZipEntry(baseFileName));
                for (String file : Arrays.asList(reportResourceDirectory.list())) {
                    this.addFileToArchive(reportArchive, file);
                }
                reportArchive.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return zipFile;
    }

    private void addFileToArchive(ZipOutputStream reportArchive, String file) throws FileNotFoundException, IOException {
        int len;
        FileInputStream asf = new FileInputStream(file);
        reportArchive.putNextEntry(new ZipEntry(file));
        byte[] buffer = new byte[18024];
        while ((len = asf.read(buffer)) > 0) {
            reportArchive.write(buffer, 0, len);
        }
        asf.close();
        reportArchive.closeEntry();
    }

    private Map<String, String> paramListToMap(List<Parameter> parameters) {
        HashMap<String, String> parmMap = new HashMap<String, String>();
        for (Parameter parm : parameters) {
            parmMap.put(parm.getName(), parm.getValue());
        }
        return parmMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Format {
        pdf,
        html,
        xml,
        xls;

    }
}

