/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;

public abstract class NumberUtils {
    public static Number convertNumberToTargetClass(Number number, Class clazz) throws IllegalArgumentException {
        if (clazz.isInstance(number)) {
            return number;
        }
        if (clazz.equals(Byte.class)) {
            long l = number.longValue();
            if (l < -128L || l > 127L) {
                NumberUtils.raiseOverflowException(number, clazz);
            }
            return number.byteValue();
        }
        if (clazz.equals(Short.class)) {
            long l = number.longValue();
            if (l < -32768L || l > 32767L) {
                NumberUtils.raiseOverflowException(number, clazz);
            }
            return number.shortValue();
        }
        if (clazz.equals(Integer.class)) {
            long l = number.longValue();
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                NumberUtils.raiseOverflowException(number, clazz);
            }
            return number.intValue();
        }
        if (clazz.equals(Long.class)) {
            return number.longValue();
        }
        if (clazz.equals(Float.class)) {
            return Float.valueOf(number.floatValue());
        }
        if (clazz.equals(Double.class)) {
            return number.doubleValue();
        }
        if (clazz.equals(BigInteger.class)) {
            return BigInteger.valueOf(number.longValue());
        }
        if (clazz.equals(BigDecimal.class)) {
            return new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unknown target class [" + clazz.getName() + "]");
    }

    private static void raiseOverflowException(Number number, Class clazz) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + clazz.getName() + "]: overflow");
    }

    public static Number parseNumber(String string, Class clazz) {
        String string2 = string.trim();
        if (clazz.equals(Byte.class)) {
            return Byte.decode(string2);
        }
        if (clazz.equals(Short.class)) {
            return Short.decode(string2);
        }
        if (clazz.equals(Integer.class)) {
            return Integer.decode(string2);
        }
        if (clazz.equals(Long.class)) {
            return Long.decode(string2);
        }
        if (clazz.equals(BigInteger.class)) {
            return NumberUtils.decodeBigInteger(string2);
        }
        if (clazz.equals(Float.class)) {
            return Float.valueOf(string2);
        }
        if (clazz.equals(Double.class)) {
            return Double.valueOf(string2);
        }
        if (clazz.equals(BigDecimal.class) || clazz.equals(Number.class)) {
            return new BigDecimal(string2);
        }
        throw new IllegalArgumentException("Cannot convert String [" + string + "] to target class [" + clazz.getName() + "]");
    }

    public static Number parseNumber(String string, Class clazz, NumberFormat numberFormat) {
        if (numberFormat != null) {
            try {
                Number number = numberFormat.parse(string.trim());
                return NumberUtils.convertNumberToTargetClass(number, clazz);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(parseException.getMessage());
            }
        }
        return NumberUtils.parseNumber(string, clazz);
    }

    private static BigInteger decodeBigInteger(String string) {
        int n = 10;
        int n2 = 0;
        boolean bl = false;
        if (string.startsWith("-")) {
            bl = true;
            ++n2;
        }
        if (string.startsWith("0x", n2) || string.startsWith("0X", n2)) {
            n2 += 2;
            n = 16;
        } else if (string.startsWith("#", n2)) {
            ++n2;
            n = 16;
        } else if (string.startsWith("0", n2) && string.length() > 1 + n2) {
            ++n2;
            n = 8;
        }
        BigInteger bigInteger = new BigInteger(string.substring(n2), n);
        return bl ? bigInteger.negate() : bigInteger;
    }
}

