/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import liquibase.exception.JDBCException;

public abstract class JdbcUtils {
    public static final int TYPE_UNKNOWN = Integer.MIN_VALUE;

    public static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
        Object object = resultSet.getObject(n);
        if (object instanceof Blob) {
            object = resultSet.getBytes(n);
        } else if (object instanceof Clob) {
            object = resultSet.getString(n);
        } else if (object != null && object.getClass().getName().startsWith("oracle.sql.TIMESTAMP")) {
            object = resultSet.getTimestamp(n);
        } else if (object != null && object.getClass().getName().startsWith("oracle.sql.DATE")) {
            String string = resultSet.getMetaData().getColumnClassName(n);
            object = "java.sql.Timestamp".equals(string) || "oracle.sql.TIMESTAMP".equals(string) ? resultSet.getTimestamp(n) : resultSet.getDate(n);
        } else if (object != null && object instanceof Date && "java.sql.Timestamp".equals(resultSet.getMetaData().getColumnClassName(n))) {
            object = resultSet.getTimestamp(n);
        }
        return object;
    }

    public static boolean isNumeric(int n) {
        return -7 == n || -5 == n || 3 == n || 8 == n || 6 == n || 4 == n || 2 == n || 7 == n || 5 == n || -6 == n;
    }

    public static Object requiredSingleResult(Collection collection) throws JDBCException {
        int n;
        int n2 = n = collection != null ? collection.size() : 0;
        if (n == 0) {
            throw new JDBCException("Empty result set, expected one row");
        }
        if (collection.size() > 1) {
            throw new JDBCException("Result set larger than one row");
        }
        return collection.iterator().next();
    }
}

