/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import liquibase.database.sql.ComputedDateValue;

public class ISODateFormat {
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private SimpleDateFormat dateTimeFormatWithDecimal = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S");
    private SimpleDateFormat dateTimeFormatWithSpace = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final String DATE_TIME_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String DATE_TIME_FORMAT_STRING_WITH_SPACE = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_TIME_FORMAT_STRING_WITH_DECIMAL = "yyyy-MM-dd'T'HH:mm:ss.S";

    public String format(java.sql.Date date) {
        return this.dateFormat.format(date);
    }

    public String format(Time time) {
        return this.timeFormat.format(time);
    }

    public String format(Timestamp timestamp) {
        return this.dateTimeFormatWithDecimal.format(timestamp);
    }

    public String format(Date date) {
        if (date instanceof ComputedDateValue) {
            return date.toString();
        }
        if (date instanceof java.sql.Date) {
            return this.format((java.sql.Date)date);
        }
        if (date instanceof Time) {
            return this.format((Time)date);
        }
        if (date instanceof Timestamp) {
            return this.format((Timestamp)date);
        }
        throw new RuntimeException("Unknown type: " + date.getClass().getName());
    }

    public Date parse(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.dateTimeFormat;
        if (string.indexOf(46) >= 0) {
            simpleDateFormat = this.dateTimeFormatWithDecimal;
        } else if (string.indexOf(32) >= 0) {
            simpleDateFormat = this.dateTimeFormatWithSpace;
        }
        if (string.length() != this.dateFormat.toPattern().length() && string.length() != this.timeFormat.toPattern().length()) {
            return new Timestamp(simpleDateFormat.parse(string).getTime());
        }
        if (string.indexOf(58) > 0) {
            return new Time(this.timeFormat.parse(string).getTime());
        }
        return new java.sql.Date(this.dateFormat.parse(string).getTime());
    }
}

