/*
 * Decompiled with CFR 0.152.
 */
package liquibase.spring;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import liquibase.FileOpener;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.JDBCException;
import liquibase.exception.LiquibaseException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SpringLiquibase
implements InitializingBean,
BeanNameAware,
ResourceLoaderAware {
    private String beanName;
    private ResourceLoader resourceLoader;
    private DataSource dataSource;
    private Logger log = Logger.getLogger(SpringLiquibase.class.getName());
    private String changeLog;
    private String contexts;

    public String getDatabaseProductName() throws JDBCException {
        Connection connection = null;
        String string = "unknown";
        try {
            connection = this.getDataSource().getConnection();
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(this.dataSource.getConnection());
            string = database.getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
        finally {
            if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    connection.close();
                }
                catch (Exception exception) {
                    this.log.log(Level.WARNING, "problem closing connection", exception);
                }
            }
        }
        return string;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String string) {
        this.changeLog = string;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String string) {
        this.contexts = string;
    }

    public void afterPropertiesSet() throws LiquibaseException {
        String string = System.getProperty("liquibase.should.run");
        if (string != null && !Boolean.valueOf(string).booleanValue()) {
            System.out.println("LiquiBase did not run because 'liquibase.should.run' system property was set to false");
            return;
        }
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
            Liquibase liquibase = this.createLiquibase(connection);
            liquibase.update(this.getContexts());
        }
        catch (SQLException sQLException) {
            throw new JDBCException(sQLException);
        }
        finally {
            if (connection != null) {
                try {
                    connection.rollback();
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private Liquibase createLiquibase(Connection connection) throws JDBCException {
        return new Liquibase(this.getChangeLog(), (FileOpener)new SpringResourceOpener(this.getChangeLog()), DatabaseFactory.getInstance().findCorrectDatabaseImplementation(connection));
    }

    public void setBeanName(String string) {
        this.beanName = string;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpringResourceOpener
    implements FileOpener {
        private String parentFile;

        public SpringResourceOpener(String string) {
            this.parentFile = string;
        }

        @Override
        public InputStream getResourceAsStream(String string) throws IOException {
            Resource resource = this.getResource(string);
            return resource.getInputStream();
        }

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            Vector<URL> vector = new Vector<URL>();
            vector.add(this.getResource(string).getURL());
            return vector.elements();
        }

        public Resource getResource(String string) {
            return SpringLiquibase.this.getResourceLoader().getResource(this.adjustClasspath(string));
        }

        private String adjustClasspath(String string) {
            return this.isClasspathPrefixPresent(this.parentFile) && !this.isClasspathPrefixPresent(string) ? "classpath:" + string : string;
        }

        public boolean isClasspathPrefixPresent(String string) {
            return string.startsWith("classpath:");
        }

        @Override
        public ClassLoader toClassLoader() {
            return SpringLiquibase.this.getResourceLoader().getClassLoader();
        }
    }
}

