/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LiquibaseStatusServlet
extends HttpServlet {
    private static List<LogRecord> liquibaseRunLog = new ArrayList<LogRecord>();

    public static synchronized void logMessage(LogRecord logRecord) {
        liquibaseRunLog.add(logRecord);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        String string = httpServletRequest.getParameter("logLevel");
        Level level = Level.INFO;
        if (string != null) {
            level = Level.parse(string);
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html>");
        printWriter.println("<head><title>LiquiBase Status</title></head>");
        printWriter.println("<body>");
        if (liquibaseRunLog.size() == 0) {
            printWriter.println("<b>LiquiBase did not run</b>");
        } else {
            printWriter.println("<b>View level: " + this.getLevelLink(Level.SEVERE, level, httpServletRequest) + " " + this.getLevelLink(Level.WARNING, level, httpServletRequest) + " " + this.getLevelLink(Level.INFO, level, httpServletRequest) + " " + this.getLevelLink(Level.CONFIG, level, httpServletRequest) + " " + this.getLevelLink(Level.FINE, level, httpServletRequest) + " " + this.getLevelLink(Level.FINER, level, httpServletRequest) + " " + this.getLevelLink(Level.FINEST, level, httpServletRequest) + "</b>");
            printWriter.println("<hr>");
            printWriter.println("<b>LiquiBase started at " + DateFormat.getDateTimeInstance().format(new Date(liquibaseRunLog.get(0).getMillis())));
            printWriter.println("<hr>");
            printWriter.println("<pre>");
            for (LogRecord logRecord : liquibaseRunLog) {
                if (logRecord.getLevel().intValue() < level.intValue()) continue;
                printWriter.println(logRecord.getLevel() + ": " + logRecord.getMessage());
                if (logRecord.getThrown() == null) continue;
                logRecord.getThrown().printStackTrace(printWriter);
            }
            printWriter.println("");
            printWriter.println("");
            printWriter.println("</pre>");
            printWriter.println("<hr>");
            printWriter.println("<b>LiquiBase finished at " + DateFormat.getDateTimeInstance().format(new Date(liquibaseRunLog.get(liquibaseRunLog.size() - 1).getMillis())));
        }
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    private String getLevelLink(Level level, Level level2, HttpServletRequest httpServletRequest) {
        if (level2.equals(level)) {
            return level.getName();
        }
        return "<a href=" + httpServletRequest.getRequestURI() + "?logLevel=" + level.getName() + ">" + level.getName() + "</a>";
    }
}

