/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servlet;

import java.sql.Connection;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.naming.InitialContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import liquibase.ClassLoaderFileOpener;
import liquibase.CompositeFileOpener;
import liquibase.FileOpener;
import liquibase.FileSystemFileOpener;
import liquibase.Liquibase;
import liquibase.database.DatabaseFactory;
import liquibase.log.LogFactory;
import liquibase.servlet.LiquibaseStatusServlet;
import liquibase.util.NetUtil;

public class LiquibaseServletListener
implements ServletContextListener {
    private String changeLogFile;
    private String dataSource;
    private String contexts;

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setContexts(String string) {
        this.contexts = string;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setChangeLogFile(String string) {
        this.changeLogFile = string;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        block20: {
            String string;
            LogFactory.getLogger().addHandler(new Handler(){

                public synchronized void publish(LogRecord logRecord) {
                    LiquibaseStatusServlet.logMessage(logRecord);
                }

                public void flush() {
                }

                public void close() throws SecurityException {
                }
            });
            try {
                string = NetUtil.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                servletContextEvent.getServletContext().log("Cannot find hostname: " + exception.getMessage());
                return;
            }
            String string2 = System.getProperty("liquibase.should.run");
            if (string2 != null && !Boolean.valueOf(string2).booleanValue()) {
                LogFactory.getLogger().info("LiquiBase did not run on " + string + " because '" + "liquibase.should.run" + "' system property was set to false");
                return;
            }
            String string3 = servletContextEvent.getServletContext().getInitParameter("LIQUIBASE_HOST_INCLUDES");
            String string4 = servletContextEvent.getServletContext().getInitParameter("LIQUIBASE_HOST_EXCLUDES");
            String string5 = servletContextEvent.getServletContext().getInitParameter("LIQUIBASE_FAIL_ON_ERROR");
            boolean bl = false;
            if (string3 == null && string4 == null) {
                bl = true;
            } else if (string3 != null) {
                for (String string6 : string3.split(",")) {
                    String object2 = string6.trim();
                    if (!string.equalsIgnoreCase(object2)) continue;
                    bl = true;
                }
            } else if (string4 != null) {
                bl = true;
                for (String string7 : string4.split(",")) {
                    String string8 = string7.trim();
                    if (!string.equalsIgnoreCase(string8)) continue;
                    bl = false;
                }
            }
            if (!bl) {
                servletContextEvent.getServletContext().log("LiquibaseServletListener did not run due to LIQUIBASE_HOST_INCLUDES and/or LIQUIBASE_HOST_EXCLUDES");
                return;
            }
            this.setDataSource(servletContextEvent.getServletContext().getInitParameter("LIQUIBASE_DATA_SOURCE"));
            this.setChangeLogFile(servletContextEvent.getServletContext().getInitParameter("LIQUIBASE_CHANGELOG"));
            this.setContexts(servletContextEvent.getServletContext().getInitParameter("LIQUIBASE_CONTEXTS"));
            if (this.getChangeLogFile() == null) {
                throw new RuntimeException("Cannot run LiquiBase, LIQUIBASE_CHANGELOG is not set");
            }
            if (this.getDataSource() == null) {
                throw new RuntimeException("Cannot run LiquiBase, LIQUIBASE_DATA_SOURCE is not set");
            }
            try {
                Object object = null;
                Connection connection = null;
                try {
                    object = new InitialContext();
                    DataSource dataSource = (DataSource)object.lookup(this.dataSource);
                    connection = dataSource.getConnection();
                    ClassLoaderFileOpener classLoaderFileOpener = new ClassLoaderFileOpener();
                    FileSystemFileOpener fileSystemFileOpener = new FileSystemFileOpener();
                    Liquibase liquibase = new Liquibase(this.getChangeLogFile(), (FileOpener)new CompositeFileOpener(classLoaderFileOpener, fileSystemFileOpener), DatabaseFactory.getInstance().findCorrectDatabaseImplementation(connection));
                    liquibase.update(this.getContexts());
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (Exception exception) {
                if ("false".equals(string5)) break block20;
                throw new RuntimeException(exception);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

