/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.exception.JDBCException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;
import liquibase.util.StringUtils;

public class TableExistsPrecondition
implements Precondition {
    private String schemaName;
    private String tableName;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void check(Database database, DatabaseChangeLog databaseChangeLog) throws PreconditionFailedException, PreconditionErrorException {
        DatabaseSnapshot databaseSnapshot = null;
        try {
            databaseSnapshot = database.createDatabaseSnapshot(this.getSchemaName(), null);
        }
        catch (JDBCException jDBCException) {
            throw new PreconditionErrorException(jDBCException, databaseChangeLog, this);
        }
        if (databaseSnapshot.getTable(this.getTableName()) == null) {
            throw new PreconditionFailedException("Table " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " does not exist", databaseChangeLog, this);
        }
    }

    public String getTagName() {
        return "tableExists";
    }
}

