/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;

public class SqlPrecondition
implements Precondition {
    private String expectedResult;
    private String sql;

    public String getExpectedResult() {
        return this.expectedResult;
    }

    public void setExpectedResult(String string) {
        this.expectedResult = string;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String string) {
        this.sql = string;
    }

    public void check(Database database, DatabaseChangeLog databaseChangeLog) throws PreconditionFailedException, PreconditionErrorException {
        Statement statement = null;
        ResultSet resultSet = null;
        DatabaseConnection databaseConnection = database.getConnection();
        try {
            statement = databaseConnection.createStatement();
            resultSet = statement.executeQuery(this.getSql());
            if (!resultSet.next()) {
                throw new PreconditionFailedException("No rows returned from SQL Precondition", databaseChangeLog, this);
            }
            String string = resultSet.getString(1);
            if (resultSet.next()) {
                throw new PreconditionFailedException("Too Many rows returned from SQL Precondition", databaseChangeLog, this);
            }
            if (!this.expectedResult.equals(string)) {
                throw new PreconditionFailedException("SQL Precondition failed.  Expected '" + this.expectedResult + "' got '" + string + "'", databaseChangeLog, this);
            }
        }
        catch (SQLException sQLException) {
            throw new PreconditionErrorException(sQLException, databaseChangeLog, this);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public String getTagName() {
        return "sqlCheck";
    }
}

