/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.exception.JDBCException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;
import liquibase.util.StringUtils;

public class SequenceExistsPrecondition
implements Precondition {
    private String schemaName;
    private String sequenceName;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String string) {
        this.sequenceName = string;
    }

    public void check(Database database, DatabaseChangeLog databaseChangeLog) throws PreconditionFailedException, PreconditionErrorException {
        DatabaseSnapshot databaseSnapshot;
        try {
            databaseSnapshot = database.createDatabaseSnapshot(this.getSchemaName(), null);
        }
        catch (JDBCException jDBCException) {
            throw new PreconditionErrorException(jDBCException, databaseChangeLog, this);
        }
        if (databaseSnapshot.getSequence(this.getSequenceName()) == null) {
            throw new PreconditionFailedException("Sequence " + database.escapeSequenceName(this.getSchemaName(), this.getSequenceName()) + " does not exist", databaseChangeLog, this);
        }
    }

    public String getTagName() {
        return "sequenceExists";
    }
}

