/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import java.sql.SQLException;
import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;

public class RunningAsPrecondition
implements Precondition {
    private String username = "";

    public void setUsername(String string) {
        this.username = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void check(Database database, DatabaseChangeLog databaseChangeLog) throws PreconditionFailedException, PreconditionErrorException {
        try {
            String string = database.getConnection().getMetaData().getUserName();
            if (string.indexOf(64) >= 0) {
                string = string.substring(0, string.indexOf(64));
            }
            if (!this.username.equalsIgnoreCase(string)) {
                throw new PreconditionFailedException("RunningAs Precondition failed: expected " + this.username + ", was " + string, databaseChangeLog, this);
            }
        }
        catch (SQLException sQLException) {
            throw new PreconditionErrorException(sQLException, databaseChangeLog, this);
        }
    }

    public String getTagName() {
        return "runningAs";
    }
}

