/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.exception.JDBCException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;
import liquibase.util.StringUtils;

public class PrimaryKeyExistsPrecondition
implements Precondition {
    private String schemaName;
    private String primaryKeyName;
    private String tableName;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public void setPrimaryKeyName(String string) {
        this.primaryKeyName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void check(Database database, DatabaseChangeLog databaseChangeLog) throws PreconditionFailedException, PreconditionErrorException {
        DatabaseSnapshot databaseSnapshot;
        try {
            databaseSnapshot = database.createDatabaseSnapshot(this.getSchemaName(), null);
        }
        catch (JDBCException jDBCException) {
            throw new PreconditionErrorException(jDBCException, databaseChangeLog, this);
        }
        if (this.tableName != null) {
            if (databaseSnapshot.getPrimaryKeyForTable(this.getTableName()) == null) {
                throw new PreconditionFailedException("Primary Key does not exist on " + database.escapeStringForDatabase(this.getTableName()), databaseChangeLog, this);
            }
        } else if (this.primaryKeyName != null) {
            if (databaseSnapshot.getPrimaryKey(this.getPrimaryKeyName()) == null) {
                throw new PreconditionFailedException("Primary Key " + database.escapeStringForDatabase(this.getPrimaryKeyName()) + " does not exist", databaseChangeLog, this);
            }
        } else {
            throw new RuntimeException("primaryKeyExists precondition requires a tableName or primaryKeyName");
        }
    }

    public String getTagName() {
        return "primaryKeyExists";
    }
}

