/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import java.util.ArrayList;
import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.FailedPrecondition;
import liquibase.preconditions.Precondition;
import liquibase.preconditions.PreconditionLogic;

public class OrPrecondition
extends PreconditionLogic {
    public void check(Database database, DatabaseChangeLog databaseChangeLog) throws PreconditionFailedException, PreconditionErrorException {
        boolean bl = false;
        ArrayList<FailedPrecondition> arrayList = new ArrayList<FailedPrecondition>();
        for (Precondition precondition : this.getNestedPreconditions()) {
            try {
                precondition.check(database, databaseChangeLog);
                bl = true;
            }
            catch (PreconditionFailedException preconditionFailedException) {
                arrayList.addAll(preconditionFailedException.getFailedPreconditions());
            }
        }
        if (!bl) {
            throw new PreconditionFailedException(arrayList);
        }
    }

    public String getTagName() {
        return "or";
    }
}

