/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.exception.JDBCException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;
import liquibase.util.StringUtils;

public class ForeignKeyExistsPrecondition
implements Precondition {
    private String schemaName;
    private String foreignKeyName;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setForeignKeyName(String string) {
        this.foreignKeyName = string;
    }

    public void check(Database database, DatabaseChangeLog databaseChangeLog) throws PreconditionFailedException, PreconditionErrorException {
        DatabaseSnapshot databaseSnapshot;
        try {
            databaseSnapshot = database.createDatabaseSnapshot(this.getSchemaName(), null);
        }
        catch (JDBCException jDBCException) {
            throw new PreconditionErrorException(jDBCException, databaseChangeLog, this);
        }
        if (databaseSnapshot.getForeignKey(this.getForeignKeyName()) == null) {
            throw new PreconditionFailedException("Foreign Key " + database.escapeStringForDatabase(this.getForeignKeyName()) + " does not exist", databaseChangeLog, this);
        }
    }

    public String getTagName() {
        return "foreignKeyConstraintExists";
    }
}

