/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;

public class DBMSPrecondition
implements Precondition {
    private String type;

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string.toLowerCase();
    }

    public void check(Database database, DatabaseChangeLog databaseChangeLog) throws PreconditionFailedException, PreconditionErrorException {
        try {
            String string = database.getTypeName();
            if (!this.type.equals(string)) {
                throw new PreconditionFailedException("DBMS Precondition failed: expected " + this.type + ", got " + string, databaseChangeLog, this);
            }
        }
        catch (PreconditionFailedException preconditionFailedException) {
            throw preconditionFailedException;
        }
        catch (Exception exception) {
            throw new PreconditionErrorException(exception, databaseChangeLog, this);
        }
    }

    public String getTagName() {
        return "dbms";
    }
}

