/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.CustomPreconditionErrorException;
import liquibase.exception.CustomPreconditionFailedException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.CustomPrecondition;
import liquibase.preconditions.ErrorPrecondition;
import liquibase.preconditions.FailedPrecondition;
import liquibase.preconditions.Precondition;
import liquibase.util.ObjectUtil;

public class CustomPreconditionWrapper
implements Precondition {
    private String className;
    private ClassLoader classLoader;
    private SortedSet<String> params = new TreeSet<String>();
    private Map<String, String> paramValues = new HashMap<String, String>();

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setParam(String string, String string2) {
        this.params.add(string);
        this.paramValues.put(string, string2);
    }

    public void check(Database database, DatabaseChangeLog databaseChangeLog) throws PreconditionFailedException, PreconditionErrorException {
        CustomPrecondition customPrecondition;
        try {
            try {
                customPrecondition = (CustomPrecondition)Class.forName(this.className, true, this.classLoader).newInstance();
            }
            catch (ClassCastException classCastException) {
                customPrecondition = (CustomPrecondition)Class.forName(this.className).newInstance();
            }
        }
        catch (Exception exception) {
            throw new PreconditionFailedException("Could not open custom precondition class " + this.className, databaseChangeLog, this);
        }
        for (String string : this.params) {
            try {
                ObjectUtil.setProperty(customPrecondition, string, this.paramValues.get(string));
            }
            catch (Exception exception) {
                throw new PreconditionFailedException("error setting parameter " + string + " on custom precondition " + this.className, databaseChangeLog, this);
            }
        }
        try {
            customPrecondition.check(database);
        }
        catch (CustomPreconditionFailedException customPreconditionFailedException) {
            throw new PreconditionFailedException(new FailedPrecondition("Custom Precondition Failed: " + customPreconditionFailedException.getMessage(), databaseChangeLog, this));
        }
        catch (CustomPreconditionErrorException customPreconditionErrorException) {
            throw new PreconditionErrorException(new ErrorPrecondition(customPreconditionErrorException.getCause(), databaseChangeLog, this));
        }
    }

    public String getTagName() {
        return "customPrecondition";
    }
}

