/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.exception.JDBCException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;
import liquibase.util.StringUtils;

public class ColumnExistsPrecondition
implements Precondition {
    private String schemaName;
    private String tableName;
    private String columnName;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public void check(Database database, DatabaseChangeLog databaseChangeLog) throws PreconditionFailedException, PreconditionErrorException {
        DatabaseSnapshot databaseSnapshot;
        try {
            databaseSnapshot = database.createDatabaseSnapshot(this.getSchemaName(), null);
        }
        catch (JDBCException jDBCException) {
            throw new PreconditionErrorException(jDBCException, databaseChangeLog, this);
        }
        if (databaseSnapshot.getColumn(this.getTableName(), this.getColumnName()) == null) {
            throw new PreconditionFailedException("Column " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " does not exist", databaseChangeLog, this);
        }
    }

    public String getTagName() {
        return "columnExists";
    }
}

