/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import liquibase.ChangeSet;
import liquibase.DatabaseChangeLog;
import liquibase.RanChangeSet;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;

public class ChangeSetExecutedPrecondition
implements Precondition {
    private String changeLogFile;
    private String id;
    private String author;

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setChangeLogFile(String string) {
        this.changeLogFile = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public void check(Database database, DatabaseChangeLog databaseChangeLog) throws PreconditionFailedException, PreconditionErrorException {
        RanChangeSet ranChangeSet;
        ChangeSet changeSet = new ChangeSet(this.getId(), this.getAuthor(), false, false, this.getChangeLogFile(), this.getChangeLogFile(), null, null, false);
        try {
            ranChangeSet = database.getRanChangeSet(changeSet);
        }
        catch (Exception exception) {
            throw new PreconditionErrorException(exception, databaseChangeLog, this);
        }
        if (ranChangeSet == null) {
            throw new PreconditionFailedException("Change Set '" + changeSet.toString(false) + "' has not been run", databaseChangeLog, this);
        }
    }

    public String getTagName() {
        return "changeSetExecuted";
    }
}

