/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import java.util.ArrayList;
import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.FailedPrecondition;
import liquibase.preconditions.Precondition;
import liquibase.preconditions.PreconditionLogic;

public class AndPrecondition
extends PreconditionLogic {
    public void check(Database database, DatabaseChangeLog databaseChangeLog) throws PreconditionFailedException, PreconditionErrorException {
        boolean bl = true;
        ArrayList<FailedPrecondition> arrayList = new ArrayList<FailedPrecondition>();
        for (Precondition precondition : this.getNestedPreconditions()) {
            try {
                precondition.check(database, databaseChangeLog);
            }
            catch (PreconditionFailedException preconditionFailedException) {
                arrayList.addAll(preconditionFailedException.getFailedPreconditions());
                bl = false;
                break;
            }
        }
        if (!bl) {
            throw new PreconditionFailedException(arrayList);
        }
    }

    public String getTagName() {
        return "and";
    }
}

