/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import liquibase.DatabaseChangeLog;
import liquibase.FileOpener;
import liquibase.exception.ChangeLogParseException;
import liquibase.log.LogFactory;
import liquibase.parser.LiquibaseSchemaResolver;
import liquibase.parser.xml.XMLChangeLogHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLChangeLogParser {
    public static String getSchemaVersion() {
        return "1.9";
    }

    public DatabaseChangeLog parse(String string, FileOpener fileOpener, Map<String, Object> map) throws ChangeLogParseException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        InputStream inputStream = null;
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            try {
                sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setEntityResolver(new LiquibaseSchemaResolver());
            xMLReader.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException sAXParseException) throws SAXException {
                    LogFactory.getLogger().warning(sAXParseException.getMessage());
                    throw sAXParseException;
                }

                public void error(SAXParseException sAXParseException) throws SAXException {
                    LogFactory.getLogger().severe(sAXParseException.getMessage());
                    throw sAXParseException;
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    LogFactory.getLogger().severe(sAXParseException.getMessage());
                    throw sAXParseException;
                }
            });
            inputStream = fileOpener.getResourceAsStream(string);
            if (inputStream == null) {
                throw new ChangeLogParseException(string + " does not exist");
            }
            XMLChangeLogHandler xMLChangeLogHandler = new XMLChangeLogHandler(string, fileOpener, map);
            xMLReader.setContentHandler(xMLChangeLogHandler);
            xMLReader.parse(new InputSource(inputStream));
            DatabaseChangeLog databaseChangeLog = xMLChangeLogHandler.getDatabaseChangeLog();
            return databaseChangeLog;
        }
        catch (ChangeLogParseException changeLogParseException) {
            throw changeLogParseException;
        }
        catch (IOException iOException) {
            throw new ChangeLogParseException("Error Reading Migration File: " + iOException.getMessage(), iOException);
        }
        catch (SAXParseException sAXParseException) {
            throw new ChangeLogParseException("Error parsing line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + " of " + string + ": " + sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            for (Throwable throwable = sAXException.getException(); throwable != null; throwable = throwable.getCause()) {
                if (!(throwable instanceof ChangeLogParseException)) continue;
                throw (ChangeLogParseException)throwable;
            }
            String string2 = sAXException.getMessage();
            String string3 = null;
            if (sAXException.getCause() != null) {
                string3 = sAXException.getCause().getMessage();
            }
            if (string2 == null) {
                string2 = string3 != null ? string3 : "Unknown Reason";
            }
            throw new ChangeLogParseException("Invalid Migration File: " + string2, sAXException);
        }
        catch (Exception exception) {
            throw new ChangeLogParseException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

