/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.xml;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.ChangeSet;
import liquibase.DatabaseChangeLog;
import liquibase.FileOpener;
import liquibase.change.AddColumnChange;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.CreateProcedureChange;
import liquibase.change.CreateTableChange;
import liquibase.change.CreateViewChange;
import liquibase.change.DeleteDataChange;
import liquibase.change.ExecuteShellCommandChange;
import liquibase.change.InsertDataChange;
import liquibase.change.LoadDataChange;
import liquibase.change.LoadDataColumnConfig;
import liquibase.change.ModifyColumnChange;
import liquibase.change.RawSQLChange;
import liquibase.change.StopChange;
import liquibase.change.UpdateDataChange;
import liquibase.change.custom.CustomChangeWrapper;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.sql.visitor.SqlVisitorFactory;
import liquibase.exception.CustomChangeException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.MigrationFailedException;
import liquibase.log.LogFactory;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ExpressionExpander;
import liquibase.preconditions.CustomPreconditionWrapper;
import liquibase.preconditions.Precondition;
import liquibase.preconditions.PreconditionFactory;
import liquibase.preconditions.PreconditionLogic;
import liquibase.preconditions.Preconditions;
import liquibase.preconditions.SqlPrecondition;
import liquibase.util.ObjectUtil;
import liquibase.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLChangeLogHandler
extends DefaultHandler {
    private static final char LIQUIBASE_FILE_SEPARATOR = '/';
    protected Logger log;
    private DatabaseChangeLog databaseChangeLog;
    private Change change;
    private StringBuffer text;
    private Preconditions rootPrecondition;
    private Stack<PreconditionLogic> preconditionLogicStack = new Stack();
    private ChangeSet changeSet;
    private String paramName;
    private FileOpener fileOpener;
    private Precondition currentPrecondition;
    private Map<String, Object> changeLogParameters = new HashMap<String, Object>();
    private boolean inRollback = false;
    private boolean inModifySql = false;
    private Collection modifySqlDbmsList;

    protected XMLChangeLogHandler(String string, FileOpener fileOpener, Map<String, Object> map) {
        this.log = LogFactory.getLogger();
        this.fileOpener = fileOpener;
        this.databaseChangeLog = new DatabaseChangeLog(string);
        this.databaseChangeLog.setPhysicalFilePath(string);
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            this.changeLogParameters.put(entry.getKey().toString(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            this.changeLogParameters.put(entry.getKey().toString(), entry.getValue());
        }
    }

    public DatabaseChangeLog getDatabaseChangeLog() {
        return this.databaseChangeLog;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block60: {
            ExpandingAttributes expandingAttributes = new ExpandingAttributes(attributes);
            try {
                if ("comment".equals(string3)) {
                    this.text = new StringBuffer();
                    break block60;
                }
                if ("validCheckSum".equals(string3)) {
                    this.text = new StringBuffer();
                    break block60;
                }
                if ("databaseChangeLog".equals(string3)) {
                    this.databaseChangeLog.setLogicalFilePath(expandingAttributes.getValue("logicalFilePath"));
                    break block60;
                }
                if ("include".equals(string3)) {
                    String string4 = expandingAttributes.getValue("file");
                    boolean bl = Boolean.parseBoolean(expandingAttributes.getValue("relativeToChangelogFile"));
                    this.handleIncludedChangeLog(string4, bl, this.databaseChangeLog.getPhysicalFilePath());
                    break block60;
                }
                if ("includeAll".equals(string3)) {
                    String string5 = expandingAttributes.getValue("path");
                    if (!string5.endsWith("/") && !string5.endsWith("\\")) {
                        string5 = string5 + "/";
                    }
                    this.log.finest("includeAll for " + string5);
                    this.log.finest("Using file opener for includeAll: " + this.fileOpener.getClass().getName());
                    Enumeration<URL> enumeration = this.fileOpener.getResources(string5);
                    boolean bl = false;
                    while (enumeration.hasMoreElements()) {
                        URL uRL = enumeration.nextElement();
                        if (!uRL.toExternalForm().startsWith("file:")) {
                            this.log.finest(uRL.toExternalForm() + " is not a file path");
                            continue;
                        }
                        File file = new File(uRL.toURI());
                        this.log.finest("includeAll using path " + file.getCanonicalPath());
                        if (!file.exists()) {
                            throw new SAXException("includeAll path " + string5 + " could not be found.  Tried in " + file.toString());
                        }
                        if (file.isDirectory()) {
                            this.log.finest(file.getCanonicalPath() + " is a directory");
                            for (File file2 : file.listFiles()) {
                                if (!this.handleIncludedChangeLog(string5 + file2.getName(), false, this.databaseChangeLog.getPhysicalFilePath())) continue;
                                bl = true;
                            }
                            continue;
                        }
                        if (!this.handleIncludedChangeLog(string5 + file.getName(), false, this.databaseChangeLog.getPhysicalFilePath())) continue;
                        bl = true;
                    }
                    if (!bl) {
                        throw new SAXException("Could not find directory " + string5);
                    }
                    break block60;
                }
                if (this.changeSet == null && "changeSet".equals(string3)) {
                    boolean bl = false;
                    boolean bl2 = false;
                    if ("true".equalsIgnoreCase(expandingAttributes.getValue("runAlways"))) {
                        bl = true;
                    }
                    if ("true".equalsIgnoreCase(expandingAttributes.getValue("runOnChange"))) {
                        bl2 = true;
                    }
                    this.changeSet = new ChangeSet(expandingAttributes.getValue("id"), expandingAttributes.getValue("author"), bl, bl2, this.databaseChangeLog.getFilePath(), this.databaseChangeLog.getPhysicalFilePath(), expandingAttributes.getValue("context"), expandingAttributes.getValue("dbms"), Boolean.valueOf(expandingAttributes.getValue("runInTransaction")));
                    if (StringUtils.trimToNull(expandingAttributes.getValue("failOnError")) != null) {
                        this.changeSet.setFailOnError(Boolean.parseBoolean(expandingAttributes.getValue("failOnError")));
                    }
                    break block60;
                }
                if (this.changeSet != null && "rollback".equals(string3)) {
                    this.text = new StringBuffer();
                    String string6 = expandingAttributes.getValue("changeSetId");
                    if (string6 != null) {
                        String string7;
                        ChangeSet changeSet;
                        String string8 = expandingAttributes.getValue("changeSetPath");
                        if (string8 == null) {
                            string8 = this.databaseChangeLog.getFilePath();
                        }
                        if ((changeSet = this.databaseChangeLog.getChangeSet(string8, string7 = expandingAttributes.getValue("changeSetAuthor"), string6)) == null) {
                            throw new SAXException("Could not find changeSet to use for rollback: " + string8 + ":" + string7 + ":" + string6);
                        }
                        for (Change change : changeSet.getChanges()) {
                            this.changeSet.addRollbackChange(change);
                        }
                    }
                    this.inRollback = true;
                    break block60;
                }
                if ("preConditions".equals(string3)) {
                    this.rootPrecondition = new Preconditions();
                    this.rootPrecondition.setOnFail(StringUtils.trimToNull(expandingAttributes.getValue("onFail")));
                    this.rootPrecondition.setOnError(StringUtils.trimToNull(expandingAttributes.getValue("onError")));
                    this.preconditionLogicStack.push(this.rootPrecondition);
                    break block60;
                }
                if (this.currentPrecondition != null && this.currentPrecondition instanceof CustomPreconditionWrapper && string3.equals("param")) {
                    ((CustomPreconditionWrapper)this.currentPrecondition).setParam(expandingAttributes.getValue("name"), expandingAttributes.getValue("value"));
                    break block60;
                }
                if (this.rootPrecondition != null) {
                    this.currentPrecondition = PreconditionFactory.getInstance().create(string3);
                    for (int i = 0; i < expandingAttributes.getLength(); ++i) {
                        String string9 = expandingAttributes.getQName(i);
                        String string10 = expandingAttributes.getValue(i);
                        this.setProperty(this.currentPrecondition, string9, string10);
                    }
                    this.preconditionLogicStack.peek().addNestedPrecondition(this.currentPrecondition);
                    if (this.currentPrecondition instanceof PreconditionLogic) {
                        this.preconditionLogicStack.push((PreconditionLogic)this.currentPrecondition);
                    }
                    if ("sqlCheck".equals(string3)) {
                        this.text = new StringBuffer();
                    }
                    break block60;
                }
                if ("modifySql".equals(string3)) {
                    this.inModifySql = true;
                    if (StringUtils.trimToNull(expandingAttributes.getValue("dbms")) != null) {
                        this.modifySqlDbmsList = StringUtils.splitAndTrim(expandingAttributes.getValue("dbms"), ",");
                    }
                    break block60;
                }
                if (this.inModifySql) {
                    SqlVisitor sqlVisitor = SqlVisitorFactory.getInstance().create(string3);
                    for (int i = 0; i < expandingAttributes.getLength(); ++i) {
                        String string11 = expandingAttributes.getQName(i);
                        String string12 = expandingAttributes.getValue(i);
                        this.setProperty(sqlVisitor, string11, string12);
                    }
                    sqlVisitor.setApplicableDbms(this.modifySqlDbmsList);
                    this.changeSet.addSqlVisitor(sqlVisitor);
                    break block60;
                }
                if (this.changeSet != null && this.change == null) {
                    this.change = ChangeFactory.getInstance().create(string3);
                    this.change.setChangeSet(this.changeSet);
                    this.text = new StringBuffer();
                    if (this.change == null) {
                        throw new MigrationFailedException(this.changeSet, "Unknown change: " + string3);
                    }
                    this.change.setFileOpener(this.fileOpener);
                    if (this.change instanceof CustomChangeWrapper) {
                        ((CustomChangeWrapper)this.change).setClassLoader(this.fileOpener.toClassLoader());
                    }
                    for (int i = 0; i < expandingAttributes.getLength(); ++i) {
                        String string13 = expandingAttributes.getQName(i);
                        String string14 = expandingAttributes.getValue(i);
                        this.setProperty(this.change, string13, string14);
                    }
                    this.change.setUp();
                    break block60;
                }
                if (this.change != null && "column".equals(string3)) {
                    ColumnConfig columnConfig = this.change instanceof LoadDataChange ? new LoadDataColumnConfig() : new ColumnConfig();
                    for (int i = 0; i < expandingAttributes.getLength(); ++i) {
                        String string15 = expandingAttributes.getQName(i);
                        String string16 = expandingAttributes.getValue(i);
                        this.setProperty(columnConfig, string15, string16);
                    }
                    if (this.change instanceof ChangeWithColumns) {
                        ((ChangeWithColumns)((Object)this.change)).addColumn(columnConfig);
                        break block60;
                    }
                    throw new RuntimeException("Unexpected column tag for " + this.change.getClass().getName());
                }
                if (this.change != null && "constraints".equals(string3)) {
                    ColumnConfig columnConfig;
                    ConstraintsConfig constraintsConfig = new ConstraintsConfig();
                    for (int i = 0; i < expandingAttributes.getLength(); ++i) {
                        String string17 = expandingAttributes.getQName(i);
                        String string18 = expandingAttributes.getValue(i);
                        this.setProperty(constraintsConfig, string17, string18);
                    }
                    if (this.change instanceof AddColumnChange) {
                        columnConfig = ((AddColumnChange)this.change).getLastColumn();
                    } else if (this.change instanceof CreateTableChange) {
                        columnConfig = ((CreateTableChange)this.change).getColumns().get(((CreateTableChange)this.change).getColumns().size() - 1);
                    } else if (this.change instanceof ModifyColumnChange) {
                        columnConfig = ((ModifyColumnChange)this.change).getColumns().get(((ModifyColumnChange)this.change).getColumns().size() - 1);
                    } else {
                        throw new RuntimeException("Unexpected change: " + this.change.getClass().getName());
                    }
                    columnConfig.setConstraints(constraintsConfig);
                    break block60;
                }
                if ("param".equals(string3)) {
                    if (this.change instanceof CustomChangeWrapper) {
                        if (expandingAttributes.getValue("value") == null) {
                            this.paramName = expandingAttributes.getValue("name");
                            this.text = new StringBuffer();
                        } else {
                            ((CustomChangeWrapper)this.change).setParam(expandingAttributes.getValue("name"), expandingAttributes.getValue("value"));
                        }
                        break block60;
                    }
                    throw new MigrationFailedException(this.changeSet, "'param' unexpected in " + string3);
                }
                if ("where".equals(string3)) {
                    this.text = new StringBuffer();
                    break block60;
                }
                if ("property".equals(string3)) {
                    if (StringUtils.trimToNull(expandingAttributes.getValue("file")) == null) {
                        this.setParameterValue(expandingAttributes.getValue("name"), expandingAttributes.getValue("value"));
                    } else {
                        Properties properties = new Properties();
                        InputStream inputStream = this.fileOpener.getResourceAsStream(expandingAttributes.getValue("file"));
                        if (inputStream == null) {
                            this.log.info("Could not open properties file " + expandingAttributes.getValue("file"));
                        } else {
                            properties.load(inputStream);
                            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                                this.setParameterValue(entry.getKey().toString(), entry.getValue().toString());
                            }
                        }
                    }
                    break block60;
                }
                if (this.change instanceof ExecuteShellCommandChange && "arg".equals(string3)) {
                    ((ExecuteShellCommandChange)this.change).addArg(expandingAttributes.getValue("value"));
                    break block60;
                }
                throw new MigrationFailedException(this.changeSet, "Unexpected tag: " + string3);
            }
            catch (Exception exception) {
                this.log.log(Level.SEVERE, "Error thrown as a SAXException: " + exception.getMessage(), exception);
                exception.printStackTrace();
                throw new SAXException(exception);
            }
        }
    }

    protected boolean handleIncludedChangeLog(String string, boolean bl, String string2) throws LiquibaseException {
        Preconditions preconditions;
        Object object;
        if (!string.endsWith(".xml") && !string.endsWith(".sql")) {
            this.log.finest(string2 + "/" + string + " is not a recognized file type");
            return false;
        }
        if (bl) {
            object = this.searchPath(string2);
            string = (String)object + string;
        }
        if ((preconditions = ((DatabaseChangeLog)(object = new ChangeLogParser(this.changeLogParameters).parse(string, this.fileOpener))).getPreconditions()) != null) {
            this.databaseChangeLog.getPreconditions().addNestedPrecondition(preconditions);
        }
        for (ChangeSet changeSet : ((DatabaseChangeLog)object).getChangeSets()) {
            this.databaseChangeLog.addChangeSet(changeSet);
        }
        return true;
    }

    private String searchPath(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            return string.substring(0, n + 1);
        }
        return string;
    }

    private void setProperty(Object object, String string, String string2) throws IllegalAccessException, InvocationTargetException, CustomChangeException {
        ExpressionExpander expressionExpander = new ExpressionExpander(this.changeLogParameters);
        if (object instanceof CustomChangeWrapper) {
            if (string.equals("class")) {
                ((CustomChangeWrapper)object).setClass(expressionExpander.expandExpressions(string2));
            } else {
                ((CustomChangeWrapper)object).setParam(string, expressionExpander.expandExpressions(string2));
            }
        } else {
            ObjectUtil.setProperty(object, string, expressionExpander.expandExpressions(string2));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = null;
        if (this.text != null && this.text.length() > 0) {
            string4 = new ExpressionExpander(this.changeLogParameters).expandExpressions(StringUtils.trimToNull(this.text.toString()));
        }
        try {
            if (this.rootPrecondition != null) {
                if ("preConditions".equals(string3)) {
                    if (this.changeSet == null) {
                        this.databaseChangeLog.setPreconditions(this.rootPrecondition);
                        this.handlePreCondition(this.rootPrecondition);
                    } else {
                        this.changeSet.setPreconditions(this.rootPrecondition);
                    }
                    this.rootPrecondition = null;
                } else if ("and".equals(string3)) {
                    this.preconditionLogicStack.pop();
                    this.currentPrecondition = null;
                } else if ("or".equals(string3)) {
                    this.preconditionLogicStack.pop();
                    this.currentPrecondition = null;
                } else if ("not".equals(string3)) {
                    this.preconditionLogicStack.pop();
                    this.currentPrecondition = null;
                } else if (string3.equals("sqlCheck")) {
                    ((SqlPrecondition)this.currentPrecondition).setSql(string4);
                    this.currentPrecondition = null;
                } else if (string3.equals("customPrecondition")) {
                    ((CustomPreconditionWrapper)this.currentPrecondition).setClassLoader(this.fileOpener.toClassLoader());
                }
            } else if (this.changeSet != null && "rollback".equals(string3)) {
                this.changeSet.addRollBackSQL(string4);
                this.inRollback = false;
            } else if (this.change != null && this.change instanceof RawSQLChange && "comment".equals(string3)) {
                ((RawSQLChange)this.change).setComments(string4);
                this.text = new StringBuffer();
            } else if (this.change != null && "where".equals(string3)) {
                if (this.change instanceof UpdateDataChange) {
                    ((UpdateDataChange)this.change).setWhereClause(string4);
                } else if (this.change instanceof DeleteDataChange) {
                    ((DeleteDataChange)this.change).setWhereClause(string4);
                } else {
                    throw new RuntimeException("Unexpected change type: " + this.change.getClass().getName());
                }
                this.text = new StringBuffer();
            } else if (this.change != null && this.change instanceof CreateProcedureChange && "comment".equals(string3)) {
                ((CreateProcedureChange)this.change).setComments(string4);
                this.text = new StringBuffer();
            } else if (this.change != null && this.change instanceof CustomChangeWrapper && this.paramName != null && "param".equals(string3)) {
                ((CustomChangeWrapper)this.change).setParam(this.paramName, string4);
                this.text = new StringBuffer();
                this.paramName = null;
            } else if (this.changeSet != null && "comment".equals(string3)) {
                this.changeSet.setComments(string4);
                this.text = new StringBuffer();
            } else if (this.changeSet != null && "changeSet".equals(string3)) {
                this.handleChangeSet(this.changeSet);
                this.changeSet = null;
            } else if (this.change != null && string3.equals("column") && string4 != null) {
                if (this.change instanceof InsertDataChange) {
                    List<ColumnConfig> list = ((InsertDataChange)this.change).getColumns();
                    list.get(list.size() - 1).setValue(string4);
                } else if (this.change instanceof UpdateDataChange) {
                    List<ColumnConfig> list = ((UpdateDataChange)this.change).getColumns();
                    list.get(list.size() - 1).setValue(string4);
                } else {
                    throw new RuntimeException("Unexpected column with text: " + string4);
                }
                this.text = new StringBuffer();
            } else if (this.change != null && string3.equals(this.change.getTagName())) {
                if (string4 != null) {
                    if (this.change instanceof RawSQLChange) {
                        ((RawSQLChange)this.change).setSql(string4);
                    } else if (this.change instanceof CreateProcedureChange) {
                        ((CreateProcedureChange)this.change).setProcedureBody(string4);
                    } else if (this.change instanceof CreateViewChange) {
                        ((CreateViewChange)this.change).setSelectQuery(string4);
                    } else if (this.change instanceof StopChange) {
                        ((StopChange)this.change).setMessage(string4);
                    } else {
                        throw new RuntimeException("Unexpected text in " + this.change.getTagName());
                    }
                }
                this.text = null;
                if (this.inRollback) {
                    this.changeSet.addRollbackChange(this.change);
                } else {
                    this.changeSet.addChange(this.change);
                }
                this.change = null;
            } else if (this.changeSet != null && "validCheckSum".equals(string3)) {
                this.changeSet.addValidCheckSum(this.text.toString());
                this.text = null;
            } else if ("modifySql".equals(string3)) {
                this.inModifySql = false;
                this.modifySqlDbmsList = null;
            }
        }
        catch (Exception exception) {
            this.log.log(Level.SEVERE, "Error thrown as a SAXException: " + exception.getMessage(), exception);
            throw new SAXException(this.databaseChangeLog.getPhysicalFilePath() + ": " + exception.getMessage(), exception);
        }
    }

    protected void handlePreCondition(Precondition precondition) {
        this.databaseChangeLog.setPreconditions(this.rootPrecondition);
    }

    protected void handleChangeSet(ChangeSet changeSet) {
        this.databaseChangeLog.addChangeSet(changeSet);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.text != null) {
            this.text.append(new String(cArray, n, n2));
        }
    }

    public Object getParameterValue(String string) {
        return this.changeLogParameters.get(string);
    }

    public void setParameterValue(String string, Object object) {
        if (!this.changeLogParameters.containsKey(string)) {
            this.changeLogParameters.put(string, object);
        }
    }

    private class ExpandingAttributes
    implements Attributes {
        private Attributes attributes;

        private ExpandingAttributes(Attributes attributes) {
            this.attributes = attributes;
        }

        public int getLength() {
            return this.attributes.getLength();
        }

        public String getURI(int n) {
            return this.attributes.getURI(n);
        }

        public String getLocalName(int n) {
            return this.attributes.getLocalName(n);
        }

        public String getQName(int n) {
            return this.attributes.getQName(n);
        }

        public String getType(int n) {
            return this.attributes.getType(n);
        }

        public String getValue(int n) {
            return this.attributes.getValue(n);
        }

        public int getIndex(String string, String string2) {
            return this.attributes.getIndex(string, string2);
        }

        public int getIndex(String string) {
            return this.attributes.getIndex(string);
        }

        public String getType(String string, String string2) {
            return this.attributes.getType(string, string2);
        }

        public String getType(String string) {
            return this.attributes.getType(string);
        }

        public String getValue(String string, String string2) {
            return new ExpressionExpander(XMLChangeLogHandler.this.changeLogParameters).expandExpressions(this.attributes.getValue(string, string2));
        }

        public String getValue(String string) {
            return new ExpressionExpander(XMLChangeLogHandler.this.changeLogParameters).expandExpressions(this.attributes.getValue(string));
        }
    }
}

