/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.ChangeSet;
import liquibase.DatabaseChangeLog;
import liquibase.RanChangeSet;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.SetupException;
import liquibase.parser.visitor.ChangeSetVisitor;
import liquibase.preconditions.ErrorPrecondition;
import liquibase.preconditions.FailedPrecondition;
import liquibase.preconditions.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingVisitor
implements ChangeSetVisitor {
    private List<ChangeSet> invalidMD5Sums = new ArrayList<ChangeSet>();
    private List<FailedPrecondition> failedPreconditions = new ArrayList<FailedPrecondition>();
    private List<ErrorPrecondition> errorPreconditions = new ArrayList<ErrorPrecondition>();
    private Set<ChangeSet> duplicateChangeSets = new HashSet<ChangeSet>();
    private List<SetupException> setupExceptions = new ArrayList<SetupException>();
    private List<InvalidChangeDefinitionException> changeValidationExceptions = new ArrayList<InvalidChangeDefinitionException>();
    private Set<String> seenChangeSets = new HashSet<String>();
    private List<RanChangeSet> ranChangeSets;

    public ValidatingVisitor(List<RanChangeSet> list) {
        this.ranChangeSets = list;
    }

    public void validate(Database database, DatabaseChangeLog databaseChangeLog) {
        try {
            Preconditions preconditions = databaseChangeLog.getPreconditions();
            if (preconditions == null) {
                return;
            }
            preconditions.check(database, databaseChangeLog);
        }
        catch (PreconditionFailedException preconditionFailedException) {
            this.failedPreconditions.addAll(preconditionFailedException.getFailedPreconditions());
        }
        catch (PreconditionErrorException preconditionErrorException) {
            this.errorPreconditions.addAll(preconditionErrorException.getErrorPreconditions());
        }
    }

    @Override
    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    @Override
    public void visit(ChangeSet changeSet, Database database) {
        for (Change object : changeSet.getChanges()) {
            try {
                object.setUp();
            }
            catch (SetupException setupException) {
                this.setupExceptions.add(setupException);
            }
            try {
                object.validate(database);
            }
            catch (InvalidChangeDefinitionException invalidChangeDefinitionException) {
                this.changeValidationExceptions.add(invalidChangeDefinitionException);
            }
        }
        for (RanChangeSet ranChangeSet : this.ranChangeSets) {
            if (!ranChangeSet.getId().equals(changeSet.getId()) || !ranChangeSet.getAuthor().equals(changeSet.getAuthor()) || !ranChangeSet.getChangeLog().equals(changeSet.getFilePath()) || changeSet.isCheckSumValid(ranChangeSet.getMd5sum()) || changeSet.shouldRunOnChange()) continue;
            this.invalidMD5Sums.add(changeSet);
        }
        String string = changeSet.toString(false);
        if (this.seenChangeSets.contains(string)) {
            this.duplicateChangeSets.add(changeSet);
        } else {
            this.seenChangeSets.add(string);
        }
    }

    public List<ChangeSet> getInvalidMD5Sums() {
        return this.invalidMD5Sums;
    }

    public List<FailedPrecondition> getFailedPreconditions() {
        return this.failedPreconditions;
    }

    public List<ErrorPrecondition> getErrorPreconditions() {
        return this.errorPreconditions;
    }

    public Set<ChangeSet> getDuplicateChangeSets() {
        return this.duplicateChangeSets;
    }

    public List<SetupException> getSetupExceptions() {
        return this.setupExceptions;
    }

    public List<InvalidChangeDefinitionException> getChangeValidationExceptions() {
        return this.changeValidationExceptions;
    }

    public boolean validationPassed() {
        return this.invalidMD5Sums.size() == 0 && this.failedPreconditions.size() == 0 && this.errorPreconditions.size() == 0 && this.duplicateChangeSets.size() == 0 && this.changeValidationExceptions.size() == 0 && this.setupExceptions.size() == 0;
    }
}

