/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.visitor;

import liquibase.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.log.LogFactory;
import liquibase.parser.visitor.ChangeSetVisitor;

public class RollbackVisitor
implements ChangeSetVisitor {
    private Database database;

    public RollbackVisitor(Database database) {
        this.database = database;
    }

    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.REVERSE;
    }

    public void visit(ChangeSet changeSet, Database database) throws LiquibaseException {
        LogFactory.getLogger().info("Rolling Back Changeset:" + changeSet);
        changeSet.rolback(this.database);
        this.database.removeRanStatus(changeSet);
        this.database.commit();
    }
}

