/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.visitor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.ChangeSet;
import liquibase.FileOpener;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.Table;
import liquibase.dbdoc.AuthorListWriter;
import liquibase.dbdoc.AuthorWriter;
import liquibase.dbdoc.ChangeLogListWriter;
import liquibase.dbdoc.ChangeLogWriter;
import liquibase.dbdoc.ColumnWriter;
import liquibase.dbdoc.PendingChangesWriter;
import liquibase.dbdoc.PendingSQLWriter;
import liquibase.dbdoc.RecentChangesWriter;
import liquibase.dbdoc.TableListWriter;
import liquibase.dbdoc.TableWriter;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.JDBCException;
import liquibase.exception.LiquibaseException;
import liquibase.parser.visitor.ChangeSetVisitor;
import liquibase.util.StreamUtil;

public class DBDocVisitor
implements ChangeSetVisitor {
    private Database database;
    private SortedSet<ChangeLogInfo> changeLogs;
    private Map<DatabaseObject, List<Change>> changesByObject;
    private Map<String, List<Change>> changesByAuthor;
    private Map<DatabaseObject, List<Change>> changesToRunByObject;
    private Map<String, List<Change>> changesToRunByAuthor;
    private List<Change> changesToRun;
    private List<Change> recentChanges;
    private String rootChangeLog;
    private static final int MAX_RECENT_CHANGE = 50;

    public DBDocVisitor(Database database) {
        this.database = database;
        this.changesByObject = new HashMap<DatabaseObject, List<Change>>();
        this.changesByAuthor = new HashMap<String, List<Change>>();
        this.changeLogs = new TreeSet<ChangeLogInfo>();
        this.changesToRunByObject = new HashMap<DatabaseObject, List<Change>>();
        this.changesToRunByAuthor = new HashMap<String, List<Change>>();
        this.changesToRun = new ArrayList<Change>();
        this.recentChanges = new ArrayList<Change>();
    }

    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    public void visit(ChangeSet changeSet, Database database) throws LiquibaseException {
        ChangeSet.RunStatus runStatus = this.database.getRunStatus(changeSet);
        if (this.rootChangeLog == null) {
            this.rootChangeLog = changeSet.getFilePath();
        }
        if (!this.changesByAuthor.containsKey(changeSet.getAuthor())) {
            this.changesByAuthor.put(changeSet.getAuthor(), new ArrayList());
        }
        if (!this.changesToRunByAuthor.containsKey(changeSet.getAuthor())) {
            this.changesToRunByAuthor.put(changeSet.getAuthor(), new ArrayList());
        }
        boolean bl = runStatus.equals((Object)ChangeSet.RunStatus.NOT_RAN) || runStatus.equals((Object)ChangeSet.RunStatus.RUN_AGAIN);
        for (Change object : changeSet.getChanges()) {
            if (bl) {
                this.changesToRunByAuthor.get(changeSet.getAuthor()).add(object);
                this.changesToRun.add(object);
                continue;
            }
            this.changesByAuthor.get(changeSet.getAuthor()).add(object);
            this.recentChanges.add(0, object);
        }
        ChangeLogInfo changeLogInfo = new ChangeLogInfo(changeSet.getFilePath(), changeSet.getPhysicalFilePath());
        if (!this.changeLogs.contains(changeLogInfo)) {
            this.changeLogs.add(changeLogInfo);
        }
        for (Change change : changeSet.getChanges()) {
            Set<DatabaseObject> set = change.getAffectedDatabaseObjects();
            if (set == null) continue;
            for (DatabaseObject databaseObject : set) {
                if (bl) {
                    if (!this.changesToRunByObject.containsKey(databaseObject)) {
                        this.changesToRunByObject.put(databaseObject, new ArrayList());
                    }
                    this.changesToRunByObject.get(databaseObject).add(change);
                }
                if (!this.changesByObject.containsKey(databaseObject)) {
                    this.changesByObject.put(databaseObject, new ArrayList());
                }
                this.changesByObject.get(databaseObject).add(change);
            }
        }
    }

    public void writeHTML(File file, FileOpener fileOpener) throws IOException, JDBCException, DatabaseHistoryException {
        ChangeLogWriter changeLogWriter = new ChangeLogWriter(fileOpener, file);
        AuthorWriter authorWriter = new AuthorWriter(file, this.database);
        TableWriter tableWriter = new TableWriter(file, this.database);
        ColumnWriter columnWriter = new ColumnWriter(file, this.database);
        PendingChangesWriter pendingChangesWriter = new PendingChangesWriter(file, this.database);
        RecentChangesWriter recentChangesWriter = new RecentChangesWriter(file, this.database);
        PendingSQLWriter pendingSQLWriter = new PendingSQLWriter(file, this.database);
        this.copyFile("liquibase/dbdoc/stylesheet.css", file);
        this.copyFile("liquibase/dbdoc/index.html", file);
        this.copyFile("liquibase/dbdoc/globalnav.html", file);
        this.copyFile("liquibase/dbdoc/overview-summary.html", file);
        DatabaseSnapshot databaseSnapshot = this.database.createDatabaseSnapshot(null, null);
        new ChangeLogListWriter(file).writeHTML(this.changeLogs);
        new TableListWriter(file).writeHTML(new TreeSet<Table>(databaseSnapshot.getTables()));
        new AuthorListWriter(file).writeHTML(new TreeSet<String>(this.changesByAuthor.keySet()));
        for (String object : this.changesByAuthor.keySet()) {
            authorWriter.writeHTML(object, this.changesByAuthor.get(object), this.changesToRunByAuthor.get(object), this.rootChangeLog);
        }
        for (Table table : databaseSnapshot.getTables()) {
            tableWriter.writeHTML(table, this.changesByObject.get(table), this.changesToRunByObject.get(table), this.rootChangeLog);
        }
        for (Column column : databaseSnapshot.getColumns()) {
            columnWriter.writeHTML(column, this.changesByObject.get(column), this.changesToRunByObject.get(column), this.rootChangeLog);
        }
        for (ChangeLogInfo changeLogInfo : this.changeLogs) {
            changeLogWriter.writeChangeLog(changeLogInfo.logicalPath, changeLogInfo.physicalPath);
        }
        pendingChangesWriter.writeHTML("index", null, this.changesToRun, this.rootChangeLog);
        pendingSQLWriter.writeHTML("sql", null, this.changesToRun, this.rootChangeLog);
        if (this.recentChanges.size() > 50) {
            this.recentChanges = this.recentChanges.subList(0, 50);
        }
        recentChangesWriter.writeHTML("index", this.recentChanges, null, this.rootChangeLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String string, File file) throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        FileOutputStream fileOutputStream = null;
        try {
            if (inputStream == null) {
                throw new IOException("Can not find " + string);
            }
            fileOutputStream = new FileOutputStream(new File(file, string.replaceFirst(".*\\/", "")), false);
            StreamUtil.copy(inputStream, fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeLogInfo
    implements Comparable<ChangeLogInfo> {
        public String logicalPath;
        public String physicalPath;

        private ChangeLogInfo(String string, String string2) {
            this.logicalPath = string;
            this.physicalPath = string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ChangeLogInfo changeLogInfo = (ChangeLogInfo)object;
            return this.logicalPath.equals(changeLogInfo.logicalPath);
        }

        public int hashCode() {
            return this.logicalPath.hashCode();
        }

        @Override
        public int compareTo(ChangeLogInfo changeLogInfo) {
            return this.logicalPath.compareTo(changeLogInfo.logicalPath);
        }

        public String toString() {
            return this.logicalPath;
        }
    }
}

