/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.filter;

import java.util.ArrayList;
import java.util.List;
import liquibase.ChangeSet;
import liquibase.RanChangeSet;
import liquibase.database.Database;
import liquibase.database.sql.UpdateStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.exception.JDBCException;
import liquibase.parser.filter.ChangeSetFilter;

public class ShouldRunChangeSetFilter
implements ChangeSetFilter {
    public List<RanChangeSet> ranChangeSets;
    private Database database;

    public ShouldRunChangeSetFilter(Database database) throws JDBCException {
        this.database = database;
        this.ranChangeSets = database.getRanChangeSetList();
    }

    public boolean accepts(ChangeSet changeSet) {
        for (RanChangeSet ranChangeSet : this.ranChangeSets) {
            if (!ranChangeSet.getId().equals(changeSet.getId()) || !ranChangeSet.getAuthor().equals(changeSet.getAuthor()) || !this.isPathEquals(changeSet, ranChangeSet)) continue;
            if (!changeSet.getMd5sum().equals(ranChangeSet.getMd5sum())) {
                UpdateStatement updateStatement = new UpdateStatement(this.database.getDefaultSchemaName(), this.database.getDatabaseChangeLogTableName());
                updateStatement.addNewColumnValue("MD5SUM", changeSet.getMd5sum());
                updateStatement.setWhereClause("ID = ? AND AUTHOR = ? AND FILENAME = ?");
                updateStatement.addWhereParameter(changeSet.getId());
                updateStatement.addWhereParameter(changeSet.getAuthor());
                updateStatement.addWhereParameter(changeSet.getFilePath());
                try {
                    this.database.getJdbcTemplate().update(updateStatement, new ArrayList<SqlVisitor>());
                }
                catch (JDBCException jDBCException) {
                    throw new RuntimeException(jDBCException);
                }
            }
            if (changeSet.shouldAlwaysRun()) {
                return true;
            }
            return changeSet.shouldRunOnChange() && !changeSet.getMd5sum().equals(ranChangeSet.getMd5sum());
        }
        return true;
    }

    private boolean isPathEquals(ChangeSet changeSet, RanChangeSet ranChangeSet) {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return ranChangeSet.getChangeLog().equalsIgnoreCase(changeSet.getFilePath());
        }
        return ranChangeSet.getChangeLog().equals(changeSet.getFilePath());
    }
}

