/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.filter;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.ChangeSet;
import liquibase.RanChangeSet;
import liquibase.parser.filter.ChangeSetFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutedAfterChangeSetFilter
implements ChangeSetFilter {
    private Set<String> changeLogsAfterDate = new HashSet<String>();

    public ExecutedAfterChangeSetFilter(Date date, List<RanChangeSet> list) {
        for (RanChangeSet ranChangeSet : list) {
            if (ranChangeSet.getDateExecuted() == null || ranChangeSet.getDateExecuted().getTime() <= date.getTime()) continue;
            this.changeLogsAfterDate.add(this.changeLogToString(ranChangeSet.getId(), ranChangeSet.getAuthor(), ranChangeSet.getChangeLog()));
        }
    }

    private String changeLogToString(String string, String string2, String string3) {
        return string + ":" + string2 + ":" + string3;
    }

    @Override
    public boolean accepts(ChangeSet changeSet) {
        return this.changeLogsAfterDate.contains(this.changeLogToString(changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath()));
    }
}

