/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.ChangeSet;
import liquibase.parser.filter.ChangeSetFilter;
import liquibase.util.StringUtils;

public class ContextChangeSetFilter
implements ChangeSetFilter {
    private Set<String> contexts = new HashSet<String>();

    public ContextChangeSetFilter(String ... stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringArray[i] = stringArray[i].toLowerCase();
            }
            if (stringArray.length == 1) {
                if (stringArray[0] != null) {
                    if (stringArray[0].indexOf(",") >= 0) {
                        this.contexts.addAll(StringUtils.splitAndTrim(stringArray[0], ","));
                    } else {
                        this.contexts.add(stringArray[0]);
                    }
                }
            } else {
                this.contexts.addAll(Arrays.asList(stringArray));
            }
        }
    }

    public boolean accepts(ChangeSet changeSet) {
        if (this.contexts == null || this.contexts.size() == 0) {
            return true;
        }
        if (changeSet.getContexts() == null) {
            return true;
        }
        for (String string : changeSet.getContexts()) {
            if (!this.contexts.contains(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

