/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.filter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.ChangeSet;
import liquibase.RanChangeSet;
import liquibase.exception.RollbackFailedException;
import liquibase.parser.filter.ChangeSetFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AfterTagChangeSetFilter
implements ChangeSetFilter {
    private Set<String> changeLogsAfterTag = new HashSet<String>();

    public AfterTagChangeSetFilter(String string, List<RanChangeSet> list) throws RollbackFailedException {
        boolean bl = false;
        for (RanChangeSet ranChangeSet : list) {
            if (bl && !string.equalsIgnoreCase(ranChangeSet.getTag())) {
                this.changeLogsAfterTag.add(this.changeLogToString(ranChangeSet.getId(), ranChangeSet.getAuthor(), ranChangeSet.getChangeLog()));
            }
            if (bl || !string.equalsIgnoreCase(ranChangeSet.getTag())) continue;
            bl = true;
        }
        if (!bl) {
            throw new RollbackFailedException("Could not find tag '" + string + "' in the database");
        }
    }

    private String changeLogToString(String string, String string2, String string3) {
        return string + ":" + string2 + ":" + string3;
    }

    @Override
    public boolean accepts(ChangeSet changeSet) {
        return this.changeLogsAfterTag.contains(this.changeLogToString(changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath()));
    }
}

