/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.ChangeSet;
import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.parser.filter.ChangeSetFilter;
import liquibase.parser.visitor.ChangeSetVisitor;

public class ChangeLogIterator {
    private DatabaseChangeLog databaseChangeLog;
    private List<ChangeSetFilter> changeSetFilters;

    public ChangeLogIterator(DatabaseChangeLog databaseChangeLog, ChangeSetFilter ... changeSetFilterArray) {
        this.databaseChangeLog = databaseChangeLog;
        this.changeSetFilters = Arrays.asList(changeSetFilterArray);
    }

    public void run(ChangeSetVisitor changeSetVisitor, Database database) throws LiquibaseException {
        List<ChangeSet> list = this.databaseChangeLog.getChangeSets();
        if (changeSetVisitor.getDirection().equals((Object)ChangeSetVisitor.Direction.REVERSE)) {
            Collections.reverse(list);
        }
        for (ChangeSet changeSet : list) {
            boolean bl = true;
            if (this.changeSetFilters != null) {
                for (ChangeSetFilter changeSetFilter : this.changeSetFilters) {
                    if (changeSetFilter.accepts(changeSet)) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            changeSetVisitor.visit(changeSet, database);
        }
    }
}

