/*
 * Decompiled with CFR 0.152.
 */
package liquibase.log;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LogFactory {
    public static Logger getLogger() {
        return Logger.getLogger("liquibase");
    }

    public static void setLoggingLevel(String string) {
        if ("all".equalsIgnoreCase(string)) {
            LogFactory.getLogger().setLevel(Level.ALL);
        } else if ("finest".equalsIgnoreCase(string)) {
            LogFactory.getLogger().setLevel(Level.FINEST);
        } else if ("finer".equalsIgnoreCase(string)) {
            LogFactory.getLogger().setLevel(Level.FINER);
        } else if ("fine".equalsIgnoreCase(string)) {
            LogFactory.getLogger().setLevel(Level.FINE);
        } else if ("info".equalsIgnoreCase(string)) {
            LogFactory.getLogger().setLevel(Level.INFO);
        } else if ("warning".equalsIgnoreCase(string)) {
            LogFactory.getLogger().setLevel(Level.WARNING);
        } else if ("severe".equalsIgnoreCase(string)) {
            LogFactory.getLogger().setLevel(Level.SEVERE);
        } else if ("off".equalsIgnoreCase(string)) {
            LogFactory.getLogger().setLevel(Level.OFF);
        } else {
            throw new IllegalArgumentException("Unknown log level: " + string);
        }
    }

    public static void setLoggingLevel(String string, String string2) {
        FileHandler fileHandler;
        try {
            fileHandler = new FileHandler(string2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot open log file " + string2 + ". Reason: " + iOException.getMessage());
        }
        fileHandler.setFormatter(new SimpleFormatter());
        LogFactory.getLogger().addHandler(fileHandler);
        LogFactory.getLogger().setUseParentHandlers(false);
        LogFactory.setLoggingLevel(string);
    }
}

