/*
 * Decompiled with CFR 0.152.
 */
package liquibase.lock;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.DatabaseChangeLogLock;
import liquibase.database.Database;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.UpdateStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.exception.JDBCException;
import liquibase.exception.LockException;
import liquibase.log.LogFactory;
import liquibase.util.NetUtil;

public class LockHandler {
    private Database database;
    private boolean hasChangeLogLock = false;
    private long changeLogLockWaitTime = 300000L;
    private static Map<Database, LockHandler> instances = new HashMap<Database, LockHandler>();

    private LockHandler(Database database) {
        this.database = database;
    }

    public static LockHandler getInstance(Database database) {
        if (!instances.containsKey(database)) {
            instances.put(database, new LockHandler(database));
        }
        return instances.get(database);
    }

    public boolean acquireLock() throws LockException {
        try {
            Boolean bl;
            this.database.checkDatabaseChangeLogLockTable();
            try {
                bl = (Boolean)this.database.getJdbcTemplate().queryForObject(this.database.getSelectChangeLogLockSQL(), Boolean.class, new ArrayList<SqlVisitor>());
            }
            catch (JDBCException jDBCException) {
                if (!this.database.getJdbcTemplate().executesStatements()) {
                    bl = false;
                }
                throw new LockException("Error checking database lock status", jDBCException);
            }
            if (bl.booleanValue()) {
                return false;
            }
            UpdateStatement updateStatement = new UpdateStatement(this.database.getDefaultSchemaName(), this.database.getDatabaseChangeLogLockTableName());
            updateStatement.addNewColumnValue("LOCKED", true);
            updateStatement.addNewColumnValue("LOCKGRANTED", new Timestamp(new Date().getTime()));
            InetAddress inetAddress = NetUtil.getLocalHost();
            updateStatement.addNewColumnValue("LOCKEDBY", inetAddress.getHostName() + " (" + inetAddress.getHostAddress() + ")");
            updateStatement.setWhereClause("ID  = 1");
            this.database.getJdbcTemplate().comment("Lock Database");
            int n = this.database.getJdbcTemplate().update(updateStatement, new ArrayList<SqlVisitor>());
            if (n != 1 && this.database.getJdbcTemplate().executesStatements()) {
                throw new LockException("Did not update change log lock correctly");
            }
            this.database.commit();
            LogFactory.getLogger().info("Successfully acquired change log lock");
            this.hasChangeLogLock = true;
            return true;
        }
        catch (Exception exception) {
            throw new LockException(exception);
        }
    }

    public void releaseLock() throws LockException {
        try {
            if (this.database.doesChangeLogLockTableExist() || !this.database.getJdbcTemplate().executesStatements()) {
                UpdateStatement updateStatement = new UpdateStatement(this.database.getDefaultSchemaName(), this.database.getDatabaseChangeLogLockTableName());
                updateStatement.addNewColumnValue("LOCKED", false);
                updateStatement.addNewColumnValue("LOCKGRANTED", null);
                updateStatement.addNewColumnValue("LOCKEDBY", null);
                updateStatement.setWhereClause(" ID = 1");
                this.database.getJdbcTemplate().comment("Release Database Lock");
                int n = this.database.getJdbcTemplate().update(updateStatement, new ArrayList<SqlVisitor>());
                if (n != 1 && this.database.getJdbcTemplate().executesStatements()) {
                    throw new LockException("Did not update change log lock correctly.\n\n" + updateStatement + " updated " + n + " instead of the expected 1 row.");
                }
                this.database.commit();
                this.hasChangeLogLock = false;
                instances.remove(this.database);
                LogFactory.getLogger().info("Successfully released change log lock");
            }
        }
        catch (Exception exception) {
            throw new LockException(exception);
        }
    }

    public DatabaseChangeLogLock[] listLocks() throws LockException {
        try {
            if (!this.database.doesChangeLogLockTableExist()) {
                return new DatabaseChangeLogLock[0];
            }
            ArrayList<DatabaseChangeLogLock> arrayList = new ArrayList<DatabaseChangeLogLock>();
            RawSqlStatement rawSqlStatement = new RawSqlStatement("SELECT ID, LOCKED, LOCKGRANTED, LOCKEDBY FROM " + this.database.escapeTableName(this.database.getDefaultSchemaName(), this.database.getDatabaseChangeLogLockTableName()));
            List<Map> list = this.database.getJdbcTemplate().queryForList((SqlStatement)rawSqlStatement, new ArrayList<SqlVisitor>());
            for (Map map : list) {
                Object v = map.get("LOCKED");
                Boolean bl = v instanceof Number ? Boolean.valueOf(((Number)v).intValue() == 1) : (Boolean)v;
                if (bl == null || !bl.booleanValue()) continue;
                arrayList.add(new DatabaseChangeLogLock(((Number)map.get("ID")).intValue(), (Date)map.get("LOCKGRANTED"), (String)map.get("LOCKEDBY")));
            }
            return arrayList.toArray(new DatabaseChangeLogLock[arrayList.size()]);
        }
        catch (Exception exception) {
            throw new LockException(exception);
        }
    }

    public void waitForLock() throws LockException {
        block9: {
            if (this.hasChangeLogLock) {
                return;
            }
            try {
                this.database.checkDatabaseChangeLogLockTable();
                boolean bl = false;
                long l = new Date().getTime() + this.changeLogLockWaitTime;
                while (!bl && new Date().getTime() < l) {
                    bl = this.acquireLock();
                    if (bl) continue;
                    System.out.println("Waiting for changelog lock....");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!bl) {
                    String string;
                    DatabaseChangeLogLock[] databaseChangeLogLockArray = this.listLocks();
                    if (databaseChangeLogLockArray.length > 0) {
                        DatabaseChangeLogLock databaseChangeLogLock = databaseChangeLogLockArray[0];
                        string = databaseChangeLogLock.getLockedBy() + " since " + DateFormat.getDateTimeInstance(3, 3).format(databaseChangeLogLock.getLockGranted());
                    } else {
                        string = "UNKNOWN";
                    }
                    throw new LockException("Could not acquire change log lock.  Currently locked by " + string);
                }
            }
            catch (JDBCException jDBCException) {
                if (!this.database.getJdbcTemplate().executesStatements()) break block9;
                throw new LockException(jDBCException);
            }
        }
    }

    public void forceReleaseLock() throws LockException, JDBCException {
        this.database.checkDatabaseChangeLogLockTable();
        this.releaseLock();
    }

    public void reset() {
        this.hasChangeLogLock = false;
    }
}

