/*
 * Decompiled with CFR 0.152.
 */
package liquibase.exception;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import liquibase.ChangeSet;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.MigrationFailedException;
import liquibase.exception.SetupException;
import liquibase.parser.visitor.ValidatingVisitor;
import liquibase.preconditions.ErrorPrecondition;
import liquibase.preconditions.FailedPrecondition;
import liquibase.util.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationFailedException
extends MigrationFailedException {
    private List<ChangeSet> invalidMD5Sums;
    private List<FailedPrecondition> failedPreconditions;
    private List<ErrorPrecondition> errorPreconditions;
    private Set<ChangeSet> duplicateChangeSets;
    private List<SetupException> setupExceptions;
    private List<InvalidChangeDefinitionException> changeValidationExceptions;

    public ValidationFailedException(ValidatingVisitor validatingVisitor) {
        this.invalidMD5Sums = validatingVisitor.getInvalidMD5Sums();
        this.failedPreconditions = validatingVisitor.getFailedPreconditions();
        this.errorPreconditions = validatingVisitor.getErrorPreconditions();
        this.duplicateChangeSets = validatingVisitor.getDuplicateChangeSets();
        this.setupExceptions = validatingVisitor.getSetupExceptions();
        this.changeValidationExceptions = validatingVisitor.getChangeValidationExceptions();
    }

    @Override
    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Validation Failed:").append(StreamUtil.getLineSeparator());
        if (this.invalidMD5Sums.size() > 0) {
            stringBuffer.append("     ").append(this.invalidMD5Sums.size()).append(" change sets check sum").append(StreamUtil.getLineSeparator());
            for (int i = 0; i < this.invalidMD5Sums.size() && i <= 25; ++i) {
                ChangeSet object = this.invalidMD5Sums.get(i);
                stringBuffer.append("          ").append(object.toString(true));
                stringBuffer.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.failedPreconditions.size() > 0) {
            stringBuffer.append("     ").append(this.failedPreconditions.size()).append(" preconditions failed").append(StreamUtil.getLineSeparator());
            for (FailedPrecondition failedPrecondition : this.failedPreconditions) {
                stringBuffer.append("     ").append(failedPrecondition.toString());
                stringBuffer.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.errorPreconditions.size() > 0) {
            stringBuffer.append("     ").append(this.errorPreconditions.size()).append(" preconditions generated an error").append(StreamUtil.getLineSeparator());
            for (ErrorPrecondition errorPrecondition : this.errorPreconditions) {
                stringBuffer.append("     ").append(errorPrecondition.toString());
                stringBuffer.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.duplicateChangeSets.size() > 0) {
            stringBuffer.append("     ").append(this.duplicateChangeSets.size()).append(" change sets had duplicate identifiers").append(StreamUtil.getLineSeparator());
            for (ChangeSet changeSet : this.duplicateChangeSets) {
                stringBuffer.append("          ").append(changeSet.toString(false));
                stringBuffer.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.setupExceptions.size() > 0) {
            stringBuffer.append("     ").append(this.setupExceptions.size()).append(" changes have failures").append(StreamUtil.getLineSeparator());
            for (SetupException setupException : this.setupExceptions) {
                stringBuffer.append("          ").append(setupException.toString());
                stringBuffer.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.changeValidationExceptions.size() > 0) {
            stringBuffer.append("     ").append(this.changeValidationExceptions.size()).append(" changes have validation failures").append(StreamUtil.getLineSeparator());
            for (InvalidChangeDefinitionException invalidChangeDefinitionException : this.changeValidationExceptions) {
                stringBuffer.append("          ").append(invalidChangeDefinitionException.toString());
                stringBuffer.append(StreamUtil.getLineSeparator());
            }
        }
        return stringBuffer.toString();
    }

    public List<ChangeSet> getInvalidMD5Sums() {
        return this.invalidMD5Sums;
    }

    public void printDescriptiveError(PrintStream printStream) {
        printStream.println("Validation Error: ");
        if (this.invalidMD5Sums.size() > 0) {
            printStream.println("     " + this.invalidMD5Sums.size() + " change sets have changed since they were ran against the database");
            for (ChangeSet object : this.invalidMD5Sums) {
                printStream.println("          " + object.toString(false));
            }
        }
        if (this.failedPreconditions.size() > 0) {
            printStream.println("     " + this.failedPreconditions.size() + " preconditions failed");
            for (FailedPrecondition failedPrecondition : this.failedPreconditions) {
                printStream.println("          " + failedPrecondition.toString());
            }
        }
        if (this.errorPreconditions.size() > 0) {
            printStream.println("     " + this.errorPreconditions.size() + " preconditions generated an error");
            for (ErrorPrecondition errorPrecondition : this.errorPreconditions) {
                printStream.println("          " + errorPrecondition.toString());
            }
        }
        if (this.duplicateChangeSets.size() > 0) {
            printStream.println("     " + this.duplicateChangeSets.size() + " change sets had duplicate identifiers");
            for (ChangeSet changeSet : this.duplicateChangeSets) {
                printStream.println("          " + changeSet.toString(false));
            }
        }
        if (this.setupExceptions.size() > 0) {
            printStream.println("     " + this.setupExceptions.size() + " changes had errors");
            for (SetupException setupException : this.setupExceptions) {
                printStream.println("          " + setupException.getMessage());
            }
        }
    }
}

