/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.change.AddColumnChange;
import liquibase.change.AddForeignKeyConstraintChange;
import liquibase.change.AddNotNullConstraintChange;
import liquibase.change.AddPrimaryKeyChange;
import liquibase.change.AddUniqueConstraintChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.CreateIndexChange;
import liquibase.change.CreateSequenceChange;
import liquibase.change.CreateTableChange;
import liquibase.change.CreateViewChange;
import liquibase.change.DropColumnChange;
import liquibase.change.DropForeignKeyConstraintChange;
import liquibase.change.DropIndexChange;
import liquibase.change.DropNotNullConstraintChange;
import liquibase.change.DropPrimaryKeyChange;
import liquibase.change.DropSequenceChange;
import liquibase.change.DropTableChange;
import liquibase.change.DropUniqueConstraintChange;
import liquibase.change.DropViewChange;
import liquibase.change.InsertDataChange;
import liquibase.change.LoadDataChange;
import liquibase.change.LoadDataColumnConfig;
import liquibase.change.ModifyColumnChange;
import liquibase.csv.opencsv.CSVWriter;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.View;
import liquibase.diff.DiffComparison;
import liquibase.exception.JDBCException;
import liquibase.log.LogFactory;
import liquibase.parser.LiquibaseSchemaResolver;
import liquibase.parser.xml.XMLChangeLogParser;
import liquibase.util.SqlUtil;
import liquibase.util.StringUtils;
import liquibase.xml.DefaultXmlWriter;
import liquibase.xml.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffResult {
    private Long baseId = new Date().getTime();
    private int changeNumber = 1;
    private Database baseDatabase;
    private Database targetDatabase;
    private DatabaseSnapshot baseSnapshot;
    private DatabaseSnapshot targetSnapshot;
    private DiffComparison productName;
    private DiffComparison productVersion;
    private SortedSet<Table> missingTables = new TreeSet<Table>();
    private SortedSet<Table> unexpectedTables = new TreeSet<Table>();
    private SortedSet<View> missingViews = new TreeSet<View>();
    private SortedSet<View> unexpectedViews = new TreeSet<View>();
    private SortedSet<Column> missingColumns = new TreeSet<Column>();
    private SortedSet<Column> unexpectedColumns = new TreeSet<Column>();
    private SortedSet<Column> changedColumns = new TreeSet<Column>();
    private SortedSet<ForeignKey> missingForeignKeys = new TreeSet<ForeignKey>();
    private SortedSet<ForeignKey> unexpectedForeignKeys = new TreeSet<ForeignKey>();
    private SortedSet<Index> missingIndexes = new TreeSet<Index>();
    private SortedSet<Index> unexpectedIndexes = new TreeSet<Index>();
    private SortedSet<PrimaryKey> missingPrimaryKeys = new TreeSet<PrimaryKey>();
    private SortedSet<PrimaryKey> unexpectedPrimaryKeys = new TreeSet<PrimaryKey>();
    private SortedSet<UniqueConstraint> missingUniqueConstraints = new TreeSet<UniqueConstraint>();
    private SortedSet<UniqueConstraint> unexpectedUniqueConstraints = new TreeSet<UniqueConstraint>();
    private SortedSet<Sequence> missingSequences = new TreeSet<Sequence>();
    private SortedSet<Sequence> unexpectedSequences = new TreeSet<Sequence>();
    private boolean diffData = false;
    private String dataDir = null;
    private String changeSetContext;
    private String changeSetAuthor;

    public DiffResult(DatabaseSnapshot databaseSnapshot, DatabaseSnapshot databaseSnapshot2) {
        this.baseDatabase = databaseSnapshot.getDatabase();
        this.targetDatabase = databaseSnapshot2.getDatabase();
        this.baseSnapshot = databaseSnapshot;
        this.targetSnapshot = databaseSnapshot2;
    }

    public DiffComparison getProductName() {
        return this.productName;
    }

    public void setProductName(DiffComparison diffComparison) {
        this.productName = diffComparison;
    }

    public DiffComparison getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(DiffComparison diffComparison) {
        this.productVersion = diffComparison;
    }

    public void addMissingTable(Table table) {
        this.missingTables.add(table);
    }

    public SortedSet<Table> getMissingTables() {
        return this.missingTables;
    }

    public void addUnexpectedTable(Table table) {
        this.unexpectedTables.add(table);
    }

    public SortedSet<Table> getUnexpectedTables() {
        return this.unexpectedTables;
    }

    public void addMissingView(View view) {
        this.missingViews.add(view);
    }

    public SortedSet<View> getMissingViews() {
        return this.missingViews;
    }

    public void addUnexpectedView(View view) {
        this.unexpectedViews.add(view);
    }

    public SortedSet<View> getUnexpectedViews() {
        return this.unexpectedViews;
    }

    public void addMissingColumn(Column column) {
        this.missingColumns.add(column);
    }

    public SortedSet<Column> getMissingColumns() {
        return this.missingColumns;
    }

    public void addUnexpectedColumn(Column column) {
        this.unexpectedColumns.add(column);
    }

    public SortedSet<Column> getUnexpectedColumns() {
        return this.unexpectedColumns;
    }

    public void addChangedColumn(Column column) {
        this.changedColumns.add(column);
    }

    public SortedSet<Column> getChangedColumns() {
        return this.changedColumns;
    }

    public void addMissingForeignKey(ForeignKey foreignKey) {
        this.missingForeignKeys.add(foreignKey);
    }

    public SortedSet<ForeignKey> getMissingForeignKeys() {
        return this.missingForeignKeys;
    }

    public void addUnexpectedForeignKey(ForeignKey foreignKey) {
        this.unexpectedForeignKeys.add(foreignKey);
    }

    public SortedSet<ForeignKey> getUnexpectedForeignKeys() {
        return this.unexpectedForeignKeys;
    }

    public void addMissingIndex(Index index) {
        this.missingIndexes.add(index);
    }

    public SortedSet<Index> getMissingIndexes() {
        return this.missingIndexes;
    }

    public void addUnexpectedIndex(Index index) {
        this.unexpectedIndexes.add(index);
    }

    public SortedSet<Index> getUnexpectedIndexes() {
        return this.unexpectedIndexes;
    }

    public void addMissingPrimaryKey(PrimaryKey primaryKey) {
        this.missingPrimaryKeys.add(primaryKey);
    }

    public SortedSet<PrimaryKey> getMissingPrimaryKeys() {
        return this.missingPrimaryKeys;
    }

    public void addUnexpectedPrimaryKey(PrimaryKey primaryKey) {
        this.unexpectedPrimaryKeys.add(primaryKey);
    }

    public SortedSet<PrimaryKey> getUnexpectedPrimaryKeys() {
        return this.unexpectedPrimaryKeys;
    }

    public void addMissingSequence(Sequence sequence) {
        this.missingSequences.add(sequence);
    }

    public SortedSet<Sequence> getMissingSequences() {
        return this.missingSequences;
    }

    public void addUnexpectedSequence(Sequence sequence) {
        this.unexpectedSequences.add(sequence);
    }

    public SortedSet<Sequence> getUnexpectedSequences() {
        return this.unexpectedSequences;
    }

    public void addMissingUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.missingUniqueConstraints.add(uniqueConstraint);
    }

    public SortedSet<UniqueConstraint> getMissingUniqueConstraints() {
        return this.missingUniqueConstraints;
    }

    public void addUnexpectedUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.unexpectedUniqueConstraints.add(uniqueConstraint);
    }

    public SortedSet<UniqueConstraint> getUnexpectedUniqueConstraints() {
        return this.unexpectedUniqueConstraints;
    }

    public boolean shouldDiffData() {
        return this.diffData;
    }

    public void setDiffData(boolean bl) {
        this.diffData = bl;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String string) {
        this.dataDir = string;
    }

    public String getChangeSetContext() {
        return this.changeSetContext;
    }

    public void setChangeSetContext(String string) {
        this.changeSetContext = string;
    }

    public void printResult(PrintStream printStream) throws JDBCException {
        printStream.println("Base Database: " + this.targetDatabase.getConnectionUsername() + " " + this.targetDatabase.getConnectionURL());
        printStream.println("Target Database: " + this.baseDatabase.getConnectionUsername() + " " + this.baseDatabase.getConnectionURL());
        this.printComparision("Product Name", this.productName, printStream);
        this.printComparision("Product Version", this.productVersion, printStream);
        this.printSetComparison("Missing Tables", this.getMissingTables(), printStream);
        this.printSetComparison("Unexpected Tables", this.getUnexpectedTables(), printStream);
        this.printSetComparison("Missing Views", this.getMissingViews(), printStream);
        this.printSetComparison("Unexpected Views", this.getUnexpectedViews(), printStream);
        this.printSetComparison("Missing Columns", this.getMissingColumns(), printStream);
        this.printSetComparison("Unexpected Columns", this.getUnexpectedColumns(), printStream);
        this.printColumnComparison(this.getChangedColumns(), printStream);
        this.printSetComparison("Missing Foreign Keys", this.getMissingForeignKeys(), printStream);
        this.printSetComparison("Unexpected Foreign Keys", this.getUnexpectedForeignKeys(), printStream);
        this.printSetComparison("Missing Primary Keys", this.getMissingPrimaryKeys(), printStream);
        this.printSetComparison("Unexpected Primary Keys", this.getUnexpectedPrimaryKeys(), printStream);
        this.printSetComparison("Missing Unique Constraints", this.getMissingUniqueConstraints(), printStream);
        this.printSetComparison("Unexpected Unique Constraints", this.getUnexpectedUniqueConstraints(), printStream);
        this.printSetComparison("Missing Indexes", this.getMissingIndexes(), printStream);
        this.printSetComparison("Unexpected Indexes", this.getUnexpectedIndexes(), printStream);
        this.printSetComparison("Missing Sequences", this.getMissingSequences(), printStream);
        this.printSetComparison("Unexpected Sequences", this.getUnexpectedSequences(), printStream);
    }

    private void printSetComparison(String string, SortedSet<?> sortedSet, PrintStream printStream) {
        printStream.print(string + ": ");
        if (sortedSet.size() == 0) {
            printStream.println("NONE");
        } else {
            printStream.println();
            for (Object e : sortedSet) {
                printStream.println("     " + e);
            }
        }
    }

    private void printColumnComparison(SortedSet<Column> sortedSet, PrintStream printStream) {
        printStream.print("Changed Columns: ");
        if (sortedSet.size() == 0) {
            printStream.println("NONE");
        } else {
            printStream.println();
            for (Column column : sortedSet) {
                printStream.println("     " + column);
                Column column2 = this.baseSnapshot.getColumn(column);
                if (column2 == null) continue;
                if (column2.isDataTypeDifferent(column)) {
                    printStream.println("           from " + column2.getDataTypeString(this.baseDatabase) + " to " + this.targetSnapshot.getColumn(column).getDataTypeString(this.targetDatabase));
                }
                if (!column2.isNullabilityDifferent(column)) continue;
                Boolean bl = this.targetSnapshot.getColumn(column).isNullable();
                if (bl == null) {
                    bl = Boolean.TRUE;
                }
                if (bl.booleanValue()) {
                    printStream.println("           now nullable");
                    continue;
                }
                printStream.println("           now not null");
            }
        }
    }

    private void printComparision(String string, DiffComparison diffComparison, PrintStream printStream) {
        printStream.print(string + ":");
        if (diffComparison.areTheSame()) {
            printStream.println(" EQUAL");
        } else {
            printStream.println();
            printStream.println("     Base:   '" + diffComparison.getBaseVersion() + "'");
            printStream.println("     Target: '" + diffComparison.getTargetVersion() + "'");
        }
    }

    public void printChangeLog(String string, Database database) throws ParserConfigurationException, IOException, JDBCException {
        this.printChangeLog(string, database, (XmlWriter)new DefaultXmlWriter());
    }

    public void printChangeLog(PrintStream printStream, Database database) throws ParserConfigurationException, IOException, JDBCException {
        this.printChangeLog(printStream, database, (XmlWriter)new DefaultXmlWriter());
    }

    public void printChangeLog(String string, Database database, XmlWriter xmlWriter) throws ParserConfigurationException, IOException, JDBCException {
        File file = new File(string);
        if (!file.exists()) {
            LogFactory.getLogger().info(file + " does not exist, creating");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.printChangeLog(new PrintStream(fileOutputStream), database, xmlWriter);
            fileOutputStream.close();
        } else {
            String string2;
            LogFactory.getLogger().info(file + " exists, appending");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.printChangeLog(new PrintStream(byteArrayOutputStream), database, xmlWriter);
            String string3 = new String(byteArrayOutputStream.toByteArray());
            string3 = string3.replaceFirst("(?ms).*<databaseChangeLog[^>]*>", "");
            string3 = string3.replaceFirst("</databaseChangeLog>", "");
            string3 = string3.trim();
            String string4 = System.getProperty("line.separator");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            long l = 0L;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf("</databaseChangeLog>");
                if (n >= 0) {
                    l += (long)n;
                    continue;
                }
                l += (long)string2.getBytes().length;
                l += (long)string4.getBytes().length;
            }
            bufferedReader.close();
            bufferedReader = new BufferedReader(new FileReader(file));
            bufferedReader.skip(l);
            bufferedReader.close();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(l);
            randomAccessFile.writeBytes("    " + string3 + string4);
            randomAccessFile.writeBytes("</databaseChangeLog>" + string4);
            randomAccessFile.close();
        }
    }

    public void printChangeLog(PrintStream printStream, Database database, XmlWriter xmlWriter) throws ParserConfigurationException, IOException, JDBCException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new LiquibaseSchemaResolver());
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("databaseChangeLog");
        element.setAttribute("xmlns", "http://www.liquibase.org/xml/ns/dbchangelog/" + XMLChangeLogParser.getSchemaVersion());
        element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttribute("xsi:schemaLocation", "http://www.liquibase.org/xml/ns/dbchangelog/" + XMLChangeLogParser.getSchemaVersion() + " http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-" + XMLChangeLogParser.getSchemaVersion() + ".xsd");
        document.appendChild(element);
        ArrayList<Change> arrayList = new ArrayList<Change>();
        this.addUnexpectedViewChanges(arrayList);
        this.addMissingTableChanges(arrayList, database);
        this.addMissingColumnChanges(arrayList, database);
        this.addChangedColumnChanges(arrayList);
        this.addMissingPrimaryKeyChanges(arrayList);
        this.addUnexpectedPrimaryKeyChanges(arrayList);
        this.addMissingUniqueConstraintChanges(arrayList);
        this.addUnexpectedUniqueConstraintChanges(arrayList);
        this.addMissingIndexChanges(arrayList);
        this.addUnexpectedIndexChanges(arrayList);
        if (this.diffData) {
            this.addInsertDataChanges(arrayList, this.dataDir);
        }
        this.addMissingForeignKeyChanges(arrayList);
        this.addUnexpectedForeignKeyChanges(arrayList);
        this.addUnexpectedColumnChanges(arrayList);
        this.addMissingSequenceChanges(arrayList);
        this.addUnexpectedSequenceChanges(arrayList);
        this.addMissingViewChanges(arrayList);
        this.addUnexpectedTableChanges(arrayList);
        for (Change change : arrayList) {
            Element element2 = document.createElement("changeSet");
            element2.setAttribute("author", this.getChangeSetAuthor());
            element2.setAttribute("id", this.generateId());
            if (this.getChangeSetContext() != null) {
                element2.setAttribute("context", this.getChangeSetContext());
            }
            element2.appendChild(change.createNode(document));
            document.getDocumentElement().appendChild(element2);
        }
        xmlWriter.write(document, printStream);
        printStream.flush();
    }

    private String getChangeSetAuthor() {
        if (this.changeSetAuthor != null) {
            return this.changeSetAuthor;
        }
        String string = System.getProperty("user.name");
        if (StringUtils.trimToNull(string) == null) {
            return "diff-generated";
        }
        return string + " (generated)";
    }

    public void setChangeSetAuthor(String string) {
        this.changeSetAuthor = string;
    }

    private String generateId() {
        return this.baseId.toString() + "-" + this.changeNumber++;
    }

    private void addUnexpectedIndexChanges(List<Change> list) {
        for (Index index : this.getUnexpectedIndexes()) {
            DropIndexChange dropIndexChange = new DropIndexChange();
            dropIndexChange.setTableName(index.getTable().getName());
            dropIndexChange.setSchemaName(index.getTable().getSchema());
            dropIndexChange.setIndexName(index.getName());
            list.add(dropIndexChange);
        }
    }

    private void addMissingIndexChanges(List<Change> list) {
        for (Index index : this.getMissingIndexes()) {
            CreateIndexChange createIndexChange = new CreateIndexChange();
            createIndexChange.setTableName(index.getTable().getName());
            createIndexChange.setSchemaName(index.getTable().getSchema());
            createIndexChange.setIndexName(index.getName());
            createIndexChange.setUnique(index.isUnique());
            for (String string : index.getColumns()) {
                ColumnConfig columnConfig = new ColumnConfig();
                columnConfig.setName(string);
                createIndexChange.addColumn(columnConfig);
            }
            list.add(createIndexChange);
        }
    }

    private void addUnexpectedPrimaryKeyChanges(List<Change> list) {
        for (PrimaryKey primaryKey : this.getUnexpectedPrimaryKeys()) {
            if (this.getUnexpectedTables().contains(primaryKey.getTable())) continue;
            DropPrimaryKeyChange dropPrimaryKeyChange = new DropPrimaryKeyChange();
            dropPrimaryKeyChange.setTableName(primaryKey.getTable().getName());
            dropPrimaryKeyChange.setSchemaName(primaryKey.getTable().getSchema());
            dropPrimaryKeyChange.setConstraintName(primaryKey.getName());
            list.add(dropPrimaryKeyChange);
        }
    }

    private void addMissingPrimaryKeyChanges(List<Change> list) {
        for (PrimaryKey primaryKey : this.getMissingPrimaryKeys()) {
            AddPrimaryKeyChange addPrimaryKeyChange = new AddPrimaryKeyChange();
            addPrimaryKeyChange.setTableName(primaryKey.getTable().getName());
            addPrimaryKeyChange.setSchemaName(primaryKey.getTable().getSchema());
            addPrimaryKeyChange.setConstraintName(primaryKey.getName());
            addPrimaryKeyChange.setColumnNames(primaryKey.getColumnNames());
            list.add(addPrimaryKeyChange);
        }
    }

    private void addUnexpectedUniqueConstraintChanges(List<Change> list) {
        for (UniqueConstraint uniqueConstraint : this.getUnexpectedUniqueConstraints()) {
            if (this.getUnexpectedTables().contains(uniqueConstraint.getTable())) continue;
            DropUniqueConstraintChange dropUniqueConstraintChange = new DropUniqueConstraintChange();
            dropUniqueConstraintChange.setTableName(uniqueConstraint.getTable().getName());
            dropUniqueConstraintChange.setSchemaName(uniqueConstraint.getTable().getSchema());
            dropUniqueConstraintChange.setConstraintName(uniqueConstraint.getName());
            list.add(dropUniqueConstraintChange);
        }
    }

    private void addMissingUniqueConstraintChanges(List<Change> list) {
        for (UniqueConstraint uniqueConstraint : this.getMissingUniqueConstraints()) {
            AddUniqueConstraintChange addUniqueConstraintChange = new AddUniqueConstraintChange();
            addUniqueConstraintChange.setTableName(uniqueConstraint.getTable().getName());
            addUniqueConstraintChange.setSchemaName(uniqueConstraint.getTable().getSchema());
            addUniqueConstraintChange.setConstraintName(uniqueConstraint.getName());
            addUniqueConstraintChange.setColumnNames(uniqueConstraint.getColumnNames());
            list.add(addUniqueConstraintChange);
        }
    }

    private void addUnexpectedForeignKeyChanges(List<Change> list) {
        for (ForeignKey foreignKey : this.getUnexpectedForeignKeys()) {
            DropForeignKeyConstraintChange dropForeignKeyConstraintChange = new DropForeignKeyConstraintChange();
            dropForeignKeyConstraintChange.setConstraintName(foreignKey.getName());
            dropForeignKeyConstraintChange.setBaseTableName(foreignKey.getForeignKeyTable().getName());
            dropForeignKeyConstraintChange.setBaseTableSchemaName(foreignKey.getForeignKeyTable().getSchema());
            list.add(dropForeignKeyConstraintChange);
        }
    }

    private void addMissingForeignKeyChanges(List<Change> list) {
        for (ForeignKey foreignKey : this.getMissingForeignKeys()) {
            AddForeignKeyConstraintChange addForeignKeyConstraintChange = new AddForeignKeyConstraintChange();
            addForeignKeyConstraintChange.setConstraintName(foreignKey.getName());
            addForeignKeyConstraintChange.setReferencedTableName(foreignKey.getPrimaryKeyTable().getName());
            addForeignKeyConstraintChange.setReferencedTableSchemaName(foreignKey.getPrimaryKeyTable().getSchema());
            addForeignKeyConstraintChange.setReferencedColumnNames(foreignKey.getPrimaryKeyColumns());
            addForeignKeyConstraintChange.setBaseTableName(foreignKey.getForeignKeyTable().getName());
            addForeignKeyConstraintChange.setBaseTableSchemaName(foreignKey.getForeignKeyTable().getSchema());
            addForeignKeyConstraintChange.setBaseColumnNames(foreignKey.getForeignKeyColumns());
            addForeignKeyConstraintChange.setDeferrable(foreignKey.isDeferrable());
            addForeignKeyConstraintChange.setInitiallyDeferred(foreignKey.isInitiallyDeferred());
            addForeignKeyConstraintChange.setUpdateRule(foreignKey.getUpdateRule());
            addForeignKeyConstraintChange.setDeleteRule(foreignKey.getDeleteRule());
            list.add(addForeignKeyConstraintChange);
        }
    }

    private void addUnexpectedSequenceChanges(List<Change> list) {
        for (Sequence sequence : this.getUnexpectedSequences()) {
            DropSequenceChange dropSequenceChange = new DropSequenceChange();
            dropSequenceChange.setSequenceName(sequence.getName());
            dropSequenceChange.setSchemaName(sequence.getSchema());
            list.add(dropSequenceChange);
        }
    }

    private void addMissingSequenceChanges(List<Change> list) {
        for (Sequence sequence : this.getMissingSequences()) {
            CreateSequenceChange createSequenceChange = new CreateSequenceChange();
            createSequenceChange.setSequenceName(sequence.getName());
            createSequenceChange.setSchemaName(sequence.getSchema());
            list.add(createSequenceChange);
        }
    }

    private void addUnexpectedColumnChanges(List<Change> list) {
        for (Column column : this.getUnexpectedColumns()) {
            if (!this.shouldModifyColumn(column)) continue;
            DropColumnChange dropColumnChange = new DropColumnChange();
            dropColumnChange.setTableName(column.getTable().getName());
            dropColumnChange.setSchemaName(column.getTable().getName());
            dropColumnChange.setColumnName(column.getName());
            list.add(dropColumnChange);
        }
    }

    private void addMissingViewChanges(List<Change> list) {
        for (View view : this.getMissingViews()) {
            CreateViewChange createViewChange = new CreateViewChange();
            createViewChange.setViewName(view.getName());
            createViewChange.setSchemaName(view.getSchema());
            String string = view.getDefinition();
            if (string == null) {
                string = "COULD NOT DETERMINE VIEW QUERY";
            }
            createViewChange.setSelectQuery(string);
            list.add(createViewChange);
        }
    }

    private void addChangedColumnChanges(List<Change> list) {
        for (Column column : this.getChangedColumns()) {
            Object object;
            if (!this.shouldModifyColumn(column)) continue;
            boolean bl = false;
            Column column2 = this.baseSnapshot.getColumn(column);
            if (column.isDataTypeDifferent(column2)) {
                object = new ColumnConfig();
                ((ColumnConfig)object).setName(column.getName());
                ((ColumnConfig)object).setType(column2.getDataTypeString(this.targetDatabase));
                ModifyColumnChange modifyColumnChange = new ModifyColumnChange();
                modifyColumnChange.setTableName(column.getTable().getName());
                modifyColumnChange.setSchemaName(column.getTable().getSchema());
                modifyColumnChange.addColumn((ColumnConfig)object);
                list.add(modifyColumnChange);
                bl = true;
            }
            if (column.isNullabilityDifferent(column2)) {
                if (column2.isNullable() == null || column2.isNullable().booleanValue()) {
                    object = new DropNotNullConstraintChange();
                    ((DropNotNullConstraintChange)object).setTableName(column.getTable().getName());
                    ((DropNotNullConstraintChange)object).setSchemaName(column.getTable().getSchema());
                    ((DropNotNullConstraintChange)object).setColumnName(column.getName());
                    ((DropNotNullConstraintChange)object).setColumnDataType(column2.getDataTypeString(this.targetDatabase));
                    list.add((Change)object);
                    bl = true;
                } else {
                    object = new AddNotNullConstraintChange();
                    ((AddNotNullConstraintChange)object).setTableName(column.getTable().getName());
                    ((AddNotNullConstraintChange)object).setSchemaName(column.getTable().getSchema());
                    ((AddNotNullConstraintChange)object).setColumnName(column.getName());
                    ((AddNotNullConstraintChange)object).setColumnDataType(column2.getDataTypeString(this.targetDatabase));
                    list.add((Change)object);
                    bl = true;
                }
            }
            if (bl) continue;
            throw new RuntimeException("Unknown difference");
        }
    }

    private boolean shouldModifyColumn(Column column) {
        return column.getView() == null && !this.baseDatabase.isLiquibaseTable(column.getTable().getName());
    }

    private void addUnexpectedViewChanges(List<Change> list) {
        for (View view : this.getUnexpectedViews()) {
            DropViewChange dropViewChange = new DropViewChange();
            dropViewChange.setViewName(view.getName());
            dropViewChange.setSchemaName(view.getSchema());
            list.add(dropViewChange);
        }
    }

    private void addMissingColumnChanges(List<Change> list, Database database) {
        for (Column column : this.getMissingColumns()) {
            if (!this.shouldModifyColumn(column)) continue;
            AddColumnChange addColumnChange = new AddColumnChange();
            addColumnChange.setTableName(column.getTable().getName());
            addColumnChange.setSchemaName(column.getTable().getSchema());
            ColumnConfig columnConfig = new ColumnConfig();
            columnConfig.setName(column.getName());
            String string = column.getDataTypeString(database);
            columnConfig.setType(string);
            String string2 = database.convertJavaObjectToString(column.getDefaultValue());
            if (string2 != null) {
                string2 = string2.replaceFirst("'", "").replaceAll("'$", "");
            }
            columnConfig.setDefaultValue(string2);
            if (column.getRemarks() != null) {
                columnConfig.setRemarks(column.getRemarks());
            }
            if (column.isNullable() != null && !column.isNullable().booleanValue()) {
                ConstraintsConfig constraintsConfig = columnConfig.getConstraints();
                if (constraintsConfig == null) {
                    constraintsConfig = new ConstraintsConfig();
                    columnConfig.setConstraints(constraintsConfig);
                }
                constraintsConfig.setNullable(false);
            }
            addColumnChange.addColumn(columnConfig);
            list.add(addColumnChange);
        }
    }

    private void addMissingTableChanges(List<Change> list, Database database) {
        for (Table table : this.getMissingTables()) {
            if (this.baseDatabase.isLiquibaseTable(table.getName())) continue;
            CreateTableChange createTableChange = new CreateTableChange();
            createTableChange.setTableName(table.getName());
            createTableChange.setSchemaName(table.getSchema());
            if (table.getRemarks() != null) {
                createTableChange.setRemarks(table.getRemarks());
            }
            for (Column column : table.getColumns()) {
                Object object;
                ColumnConfig columnConfig = new ColumnConfig();
                columnConfig.setName(column.getName());
                columnConfig.setType(column.getDataTypeString(database));
                ConstraintsConfig constraintsConfig = null;
                if (column.isPrimaryKey()) {
                    object = null;
                    for (PrimaryKey primaryKey : this.getMissingPrimaryKeys()) {
                        if (!primaryKey.getTable().getName().equalsIgnoreCase(table.getName())) continue;
                        object = primaryKey;
                    }
                    if (object == null || ((PrimaryKey)object).getColumnNamesAsList().size() == 1) {
                        constraintsConfig = new ConstraintsConfig();
                        constraintsConfig.setPrimaryKey(true);
                        if (object != null) {
                            constraintsConfig.setPrimaryKeyName(((PrimaryKey)object).getName());
                            this.getMissingPrimaryKeys().remove(object);
                        }
                    }
                }
                if (column.isAutoIncrement()) {
                    columnConfig.setAutoIncrement(true);
                }
                if (column.isNullable() != null && !column.isNullable().booleanValue()) {
                    if (constraintsConfig == null) {
                        constraintsConfig = new ConstraintsConfig();
                    }
                    constraintsConfig.setNullable(false);
                }
                if (constraintsConfig != null) {
                    columnConfig.setConstraints(constraintsConfig);
                }
                if ((object = column.getDefaultValue()) != null && !column.isAutoIncrement()) {
                    if (object instanceof Date) {
                        columnConfig.setDefaultValueDate((Date)object);
                    } else if (object instanceof Boolean) {
                        columnConfig.setDefaultValueBoolean((Boolean)object);
                    } else if (object instanceof Number) {
                        columnConfig.setDefaultValueNumeric((Number)object);
                    } else {
                        columnConfig.setDefaultValue(object.toString());
                    }
                }
                if (column.getRemarks() != null) {
                    columnConfig.setRemarks(column.getRemarks());
                }
                createTableChange.addColumn(columnConfig);
            }
            list.add(createTableChange);
        }
    }

    private void addUnexpectedTableChanges(List<Change> list) {
        for (Table table : this.getUnexpectedTables()) {
            DropTableChange dropTableChange = new DropTableChange();
            dropTableChange.setTableName(table.getName());
            dropTableChange.setSchemaName(table.getSchema());
            list.add(dropTableChange);
        }
    }

    private void addInsertDataChanges(List<Change> list, String string) throws JDBCException, IOException {
        try {
            String string2 = this.baseSnapshot.getSchema();
            Statement statement = this.baseSnapshot.getDatabase().getConnection().createStatement();
            for (Table table : this.baseSnapshot.getTables()) {
                Object object;
                Object object2;
                ResultSet resultSet = statement.executeQuery("SELECT * FROM " + this.baseSnapshot.getDatabase().escapeTableName(string2, table.getName()));
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                if (string != null) {
                    File file;
                    object2 = table.getName() + ".csv";
                    if (string != null) {
                        object2 = string + "/" + (String)object2;
                    }
                    if (!(file = new File(string)).exists()) {
                        file.mkdirs();
                    }
                    if (!file.isDirectory()) {
                        throw new RuntimeException(file + " is not a directory");
                    }
                    object = new liquibase.csv.CSVWriter(new FileWriter((String)object2));
                    ((liquibase.csv.CSVWriter)object).writeAll(resultSet, true);
                    ((CSVWriter)object).flush();
                    ((CSVWriter)object).close();
                    LoadDataChange loadDataChange = new LoadDataChange();
                    loadDataChange.setFile((String)object2);
                    loadDataChange.setEncoding("UTF-8");
                    loadDataChange.setSchemaName(string2);
                    loadDataChange.setTableName(table.getName());
                    for (int i = 1; i <= n; ++i) {
                        String string3 = resultSetMetaData.getColumnName(i);
                        int n2 = resultSetMetaData.getColumnType(i);
                        String string4 = "STRING";
                        if (SqlUtil.isNumeric(n2)) {
                            string4 = "NUMERIC";
                        } else if (SqlUtil.isBoolean(n2)) {
                            string4 = "BOOLEAN";
                        } else if (SqlUtil.isDate(n2)) {
                            string4 = "DATE";
                        }
                        LoadDataColumnConfig loadDataColumnConfig = new LoadDataColumnConfig();
                        loadDataColumnConfig.setHeader(string3);
                        loadDataColumnConfig.setType(string4);
                        loadDataChange.addColumn(loadDataColumnConfig);
                    }
                    list.add(loadDataChange);
                    continue;
                }
                while (resultSet.next()) {
                    object2 = new InsertDataChange();
                    ((InsertDataChange)object2).setSchemaName(string2);
                    ((InsertDataChange)object2).setTableName(table.getName());
                    for (int i = 1; i <= n; ++i) {
                        object = new ColumnConfig();
                        ((ColumnConfig)object).setName(resultSetMetaData.getColumnName(i));
                        int n3 = resultSetMetaData.getColumnType(i);
                        if (SqlUtil.isNumeric(n3)) {
                            String string5 = resultSet.getString(i);
                            if (string5 == null) {
                                ((ColumnConfig)object).setValueNumeric((Number)null);
                            } else if (n3 == 8 || n3 == 2 || n3 == 3) {
                                ((ColumnConfig)object).setValueNumeric(new Double(string5));
                            } else if (n3 == 6 || n3 == 7) {
                                ((ColumnConfig)object).setValueNumeric(new Float(string5));
                            } else {
                                ((ColumnConfig)object).setValueNumeric(new Integer(string5));
                            }
                        } else if (SqlUtil.isBoolean(n3)) {
                            ((ColumnConfig)object).setValueBoolean(resultSet.getBoolean(i));
                        } else if (SqlUtil.isDate(n3)) {
                            ((ColumnConfig)object).setValueDate(resultSet.getDate(i));
                        } else {
                            ((ColumnConfig)object).setValue(resultSet.getString(i));
                        }
                        ((InsertDataChange)object2).addColumn((ColumnConfig)object);
                    }
                    list.add((Change)object2);
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

