/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.UnsupportedDatabaseSnapshot;
import liquibase.database.structure.View;
import liquibase.diff.DiffComparison;
import liquibase.diff.DiffResult;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.util.StringUtils;

public class Diff {
    private Database baseDatabase;
    private Database targetDatabase;
    private DatabaseSnapshot baseSnapshot;
    private DatabaseSnapshot targetSnapshot;
    private Set<DiffStatusListener> statusListeners = new HashSet<DiffStatusListener>();
    private boolean diffTables = true;
    private boolean diffColumns = true;
    private boolean diffViews = true;
    private boolean diffPrimaryKeys = true;
    private boolean diffUniqueConstraints = true;
    private boolean diffIndexes = true;
    private boolean diffForeignKeys = true;
    private boolean diffSequences = true;
    private boolean diffData = false;

    public Diff(Database database, Database database2) {
        this.baseDatabase = database;
        this.targetDatabase = database2;
    }

    public Diff(Database database, String string) throws JDBCException {
        this.targetDatabase = null;
        this.baseDatabase = database;
        this.baseDatabase.setDefaultSchemaName(string);
    }

    public Diff(DatabaseSnapshot databaseSnapshot, DatabaseSnapshot databaseSnapshot2) {
        this.baseSnapshot = databaseSnapshot;
        this.targetSnapshot = databaseSnapshot2;
    }

    public void addStatusListener(DiffStatusListener diffStatusListener) {
        this.statusListeners.add(diffStatusListener);
    }

    public void removeStatusListener(DiffStatusListener diffStatusListener) {
        this.statusListeners.remove(diffStatusListener);
    }

    public DiffResult compare() throws JDBCException {
        if (this.baseSnapshot == null) {
            this.baseSnapshot = this.baseDatabase.createDatabaseSnapshot(null, this.statusListeners);
        }
        if (this.targetSnapshot == null) {
            this.targetSnapshot = this.targetDatabase == null ? new UnsupportedDatabaseSnapshot() : this.targetDatabase.createDatabaseSnapshot(null, this.statusListeners);
        }
        DiffResult diffResult = new DiffResult(this.baseSnapshot, this.targetSnapshot);
        this.checkVersionInfo(diffResult);
        if (this.shouldDiffTables()) {
            this.checkTables(diffResult);
        }
        if (this.shouldDiffViews()) {
            this.checkViews(diffResult);
        }
        if (this.shouldDiffColumns()) {
            this.checkColumns(diffResult);
        }
        if (this.shouldDiffForeignKeys()) {
            this.checkForeignKeys(diffResult);
        }
        if (this.shouldDiffPrimaryKeys()) {
            this.checkPrimaryKeys(diffResult);
        }
        if (this.shouldDiffUniqueConstraints()) {
            this.checkUniqueConstraints(diffResult);
        }
        if (this.shouldDiffIndexes()) {
            this.checkIndexes(diffResult);
        }
        if (this.shouldDiffSequences()) {
            this.checkSequences(diffResult);
        }
        diffResult.setDiffData(this.shouldDiffData());
        return diffResult;
    }

    public void setDiffTypes(String string) {
        if (StringUtils.trimToNull(string) != null) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(string.toLowerCase().split("\\s*,\\s*")));
            this.diffTables = hashSet.contains("tables");
            this.diffColumns = hashSet.contains("columns");
            this.diffViews = hashSet.contains("views");
            this.diffPrimaryKeys = hashSet.contains("primaryKeys");
            this.diffUniqueConstraints = hashSet.contains("uniqueConstraints");
            this.diffIndexes = hashSet.contains("indexes");
            this.diffForeignKeys = hashSet.contains("foreignKeys");
            this.diffSequences = hashSet.contains("sequences");
            this.diffData = hashSet.contains("data");
        }
    }

    public boolean shouldDiffTables() {
        return this.diffTables;
    }

    public void setDiffTables(boolean bl) {
        this.diffTables = bl;
    }

    public boolean shouldDiffColumns() {
        return this.diffColumns;
    }

    public void setDiffColumns(boolean bl) {
        this.diffColumns = bl;
    }

    public boolean shouldDiffViews() {
        return this.diffViews;
    }

    public void setDiffViews(boolean bl) {
        this.diffViews = bl;
    }

    public boolean shouldDiffPrimaryKeys() {
        return this.diffPrimaryKeys;
    }

    public void setDiffPrimaryKeys(boolean bl) {
        this.diffPrimaryKeys = bl;
    }

    public boolean shouldDiffIndexes() {
        return this.diffIndexes;
    }

    public void setDiffIndexes(boolean bl) {
        this.diffIndexes = bl;
    }

    public boolean shouldDiffForeignKeys() {
        return this.diffForeignKeys;
    }

    public void setDiffForeignKeys(boolean bl) {
        this.diffForeignKeys = bl;
    }

    public boolean shouldDiffSequences() {
        return this.diffSequences;
    }

    public void setDiffSequences(boolean bl) {
        this.diffSequences = bl;
    }

    public boolean shouldDiffData() {
        return this.diffData;
    }

    public void setDiffData(boolean bl) {
        this.diffData = bl;
    }

    public boolean shouldDiffUniqueConstraints() {
        return this.diffUniqueConstraints;
    }

    public void setDiffUniqueConstraints(boolean bl) {
        this.diffUniqueConstraints = bl;
    }

    private void checkVersionInfo(DiffResult diffResult) throws JDBCException {
        if (this.targetDatabase != null) {
            diffResult.setProductName(new DiffComparison(this.baseDatabase.getDatabaseProductName(), this.targetDatabase.getDatabaseProductName()));
            diffResult.setProductVersion(new DiffComparison(this.baseDatabase.getDatabaseProductVersion(), this.targetDatabase.getDatabaseProductVersion()));
        }
    }

    private void checkTables(DiffResult diffResult) {
        for (Table table : this.baseSnapshot.getTables()) {
            if (this.targetSnapshot.getTables().contains(table)) continue;
            diffResult.addMissingTable(table);
        }
        for (Table table : this.targetSnapshot.getTables()) {
            if (this.baseSnapshot.getTables().contains(table)) continue;
            diffResult.addUnexpectedTable(table);
        }
    }

    private void checkViews(DiffResult diffResult) {
        for (View view : this.baseSnapshot.getViews()) {
            if (this.targetSnapshot.getViews().contains(view)) continue;
            diffResult.addMissingView(view);
        }
        for (View view : this.targetSnapshot.getViews()) {
            if (this.baseSnapshot.getViews().contains(view)) continue;
            diffResult.addUnexpectedView(view);
        }
    }

    private void checkColumns(DiffResult diffResult) {
        for (Column column : this.baseSnapshot.getColumns()) {
            if (this.targetSnapshot.getColumns().contains(column) || column.getTable() != null && diffResult.getMissingTables().contains(column.getTable()) || column.getView() != null && diffResult.getMissingViews().contains(column.getView())) continue;
            diffResult.addMissingColumn(column);
        }
        for (Column column : this.targetSnapshot.getColumns()) {
            Column column2;
            if (!(this.baseSnapshot.getColumns().contains(column) || column.getTable() != null && diffResult.getUnexpectedTables().contains(column.getTable()) || column.getView() != null && diffResult.getUnexpectedViews().contains(column.getView()))) {
                diffResult.addUnexpectedColumn(column);
                continue;
            }
            if (column.getTable() == null || diffResult.getUnexpectedTables().contains(column.getTable()) || (column2 = this.baseSnapshot.getColumn(column.getTable().getName(), column.getName())) != null && !column.isDifferent(column2)) continue;
            diffResult.addChangedColumn(column);
        }
    }

    private void checkForeignKeys(DiffResult diffResult) {
        for (ForeignKey foreignKey : this.baseSnapshot.getForeignKeys()) {
            if (this.targetSnapshot.getForeignKeys().contains(foreignKey)) continue;
            diffResult.addMissingForeignKey(foreignKey);
        }
        for (ForeignKey foreignKey : this.targetSnapshot.getForeignKeys()) {
            if (this.baseSnapshot.getForeignKeys().contains(foreignKey)) continue;
            diffResult.addUnexpectedForeignKey(foreignKey);
        }
    }

    private void checkUniqueConstraints(DiffResult diffResult) {
        for (UniqueConstraint uniqueConstraint : this.baseSnapshot.getUniqueConstraints()) {
            if (this.targetSnapshot.getUniqueConstraints().contains(uniqueConstraint)) continue;
            diffResult.addMissingUniqueConstraint(uniqueConstraint);
        }
        for (UniqueConstraint uniqueConstraint : this.targetSnapshot.getUniqueConstraints()) {
            if (this.baseSnapshot.getUniqueConstraints().contains(uniqueConstraint)) continue;
            diffResult.addUnexpectedUniqueConstraint(uniqueConstraint);
        }
    }

    private void checkIndexes(DiffResult diffResult) {
        for (Index index : this.baseSnapshot.getIndexes()) {
            if (this.targetSnapshot.getIndexes().contains(index)) continue;
            diffResult.addMissingIndex(index);
        }
        for (Index index : this.targetSnapshot.getIndexes()) {
            if (this.baseSnapshot.getIndexes().contains(index)) continue;
            diffResult.addUnexpectedIndex(index);
        }
    }

    private void checkPrimaryKeys(DiffResult diffResult) {
        for (PrimaryKey primaryKey : this.baseSnapshot.getPrimaryKeys()) {
            if (this.targetSnapshot.getPrimaryKeys().contains(primaryKey)) continue;
            diffResult.addMissingPrimaryKey(primaryKey);
        }
        for (PrimaryKey primaryKey : this.targetSnapshot.getPrimaryKeys()) {
            if (this.baseSnapshot.getPrimaryKeys().contains(primaryKey)) continue;
            diffResult.addUnexpectedPrimaryKey(primaryKey);
        }
    }

    private void checkSequences(DiffResult diffResult) {
        for (Sequence sequence : this.baseSnapshot.getSequences()) {
            if (this.targetSnapshot.getSequences().contains(sequence)) continue;
            diffResult.addMissingSequence(sequence);
        }
        for (Sequence sequence : this.targetSnapshot.getSequences()) {
            if (this.baseSnapshot.getSequences().contains(sequence)) continue;
            diffResult.addUnexpectedSequence(sequence);
        }
    }
}

