/*
 * Decompiled with CFR 0.152.
 */
package liquibase.dbdoc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import liquibase.ChangeSet;
import liquibase.Liquibase;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.dbdoc.HTMLWriter;
import liquibase.exception.MigrationFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingSQLWriter
extends HTMLWriter {
    public PendingSQLWriter(File file, Database database) {
        super(new File(file, "pending"), database);
    }

    @Override
    protected String createTitle(Object object) {
        return "Pending SQL";
    }

    protected void writeBody(FileWriter fileWriter, Object object, List<Change> list, List<Change> list2, Liquibase liquibase) throws IOException {
        if (list2.size() == 0) {
            fileWriter.append("<b>NONE</b>");
        }
        fileWriter.append("<code><pre>");
        ChangeSet changeSet = null;
        for (Change change : list2) {
            ChangeSet changeSet2 = change.getChangeSet();
            if (changeSet2.equals(changeSet)) continue;
            changeSet = changeSet2;
            String string = changeSet2.toString(false).replaceAll("\\W", "_");
            fileWriter.append("<a name='").append(string).append("'/>");
            try {
                changeSet2.execute(liquibase.getDatabase());
            }
            catch (MigrationFailedException migrationFailedException) {
                fileWriter.append("EXECUTION ERROR: ").append(change.getChangeName()).append(": ").append(migrationFailedException.getMessage()).append("\n\n");
            }
        }
        fileWriter.append("</pre></code>");
    }

    @Override
    protected void writeCustomHTML(FileWriter fileWriter, Object object, List<Change> list, Database database) throws IOException {
    }
}

