/*
 * Decompiled with CFR 0.152.
 */
package liquibase.dbdoc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import liquibase.ChangeSet;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.JDBCException;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTMLWriter {
    protected File outputDir;
    protected Database database;

    public HTMLWriter(File file, Database database) {
        this.outputDir = file;
        this.database = database;
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    protected abstract void writeCustomHTML(FileWriter var1, Object var2, List<Change> var3, Database var4) throws IOException;

    private FileWriter createFileWriter(Object object) throws IOException {
        return new FileWriter(new File(this.outputDir, object.toString().toLowerCase() + ".html"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHTML(Object object, List<Change> list, List<Change> list2, String string) throws IOException, DatabaseHistoryException, JDBCException {
        FileWriter fileWriter = this.createFileWriter(object);
        try {
            fileWriter.append("<html>");
            this.writeHeader(object, fileWriter);
            fileWriter.append("<body BGCOLOR=\"white\" onload=\"windowTitle();\">");
            fileWriter.append("<H2>").append(this.createTitle(object)).append("</H2>\n");
            this.writeBody(fileWriter, object, list, list2);
            this.writeFooter(fileWriter, string);
            fileWriter.append("</body>");
            fileWriter.append("</html>");
        }
        finally {
            fileWriter.close();
        }
    }

    private void writeFooter(FileWriter fileWriter, String string) throws IOException {
        fileWriter.append("<hr>Generated: ");
        fileWriter.append(DateFormat.getDateTimeInstance(3, 3).format(new Date()));
        fileWriter.append("<BR>Against: ");
        fileWriter.append(this.database.toString());
        fileWriter.append("<BR>Change Log: ");
        fileWriter.append(string);
        fileWriter.append("<BR><BR>Generated By: ");
        fileWriter.append("<a href='http://www.liquibase.org' target='_TOP'>LiquiBase ").append(LiquibaseUtil.getBuildVersion()).append("</a>");
    }

    protected void writeBody(FileWriter fileWriter, Object object, List<Change> list, List<Change> list2) throws IOException, DatabaseHistoryException, JDBCException {
        this.writeCustomHTML(fileWriter, object, list, this.database);
        this.writeChanges("Pending Changes", fileWriter, list2);
        this.writeChanges("Past Changes", fileWriter, list);
    }

    protected void writeTable(String string, List<List<String>> list, FileWriter fileWriter) throws IOException {
        fileWriter.append("<P>");
        int n = 0;
        n = list.size() == 0 ? 0 : list.get(0).size();
        fileWriter.append("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n").append("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n").append("<TD COLSPAN=").append(String.valueOf(n)).append("><FONT SIZE=\"+2\">\n").append("<B>").append(string).append("</B></FONT></TD>\n").append("</TR>\n");
        for (List<String> list2 : list) {
            fileWriter.append("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n");
            for (String string2 : list2) {
                this.writeTD(fileWriter, string2);
            }
            fileWriter.append("</TR>\n");
        }
        fileWriter.append("</TABLE>\n");
    }

    private void writeTD(FileWriter fileWriter, String string) throws IOException {
        fileWriter.append("<TD VALIGN=\"top\">\n");
        fileWriter.append(string);
        fileWriter.append("</TD>\n");
    }

    private void writeHeader(Object object, FileWriter fileWriter) throws IOException {
        String string = this.createTitle(object);
        fileWriter.append("<head>").append("<title>").append(string).append("</title>").append("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"../../stylesheet.css\" TITLE=\"Style\">").append("<SCRIPT type=\"text/javascript\">").append("function windowTitle()").append("{").append("    parent.document.title=\"").append(string).append("\";").append("}").append("</SCRIPT>").append("</head>");
    }

    protected abstract String createTitle(Object var1);

    protected void writeChanges(String string, FileWriter fileWriter, List<Change> list) throws IOException, DatabaseHistoryException, JDBCException {
        fileWriter.append("<p><TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n");
        fileWriter.append("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n");
        fileWriter.append("<TD COLSPAN='4'><FONT SIZE=\"+2\">\n");
        fileWriter.append("<B>");
        fileWriter.append(string);
        fileWriter.append("</B></FONT></TD>\n");
        fileWriter.append("</TR>\n");
        ChangeSet changeSet = null;
        if (list == null || list.size() == 0) {
            fileWriter.append("<tr><td>None Found</td></tr>");
        } else {
            for (Change change : list) {
                if (!change.getChangeSet().equals(changeSet)) {
                    changeSet = change.getChangeSet();
                    fileWriter.append("<TR BGCOLOR=\"#EEEEFF\" CLASS=\"TableSubHeadingColor\">\n");
                    this.writeTD(fileWriter, "<a href='../changelogs/" + change.getChangeSet().getFilePath() + ".xml'>" + change.getChangeSet().getFilePath() + "</a>");
                    this.writeTD(fileWriter, change.getChangeSet().getId());
                    this.writeTD(fileWriter, "<a href='../authors/" + change.getChangeSet().getAuthor().toLowerCase() + ".html'>" + change.getChangeSet().getAuthor().toLowerCase() + "</a>");
                    ChangeSet.RunStatus runStatus = this.database.getRunStatus(change.getChangeSet());
                    if (runStatus.equals((Object)ChangeSet.RunStatus.NOT_RAN)) {
                        String string2 = change.getChangeSet().toString(false).replaceAll("\\W", "_");
                        this.writeTD(fileWriter, "NOT YET RAN [<a href='../pending/sql.html#" + string2 + "'>SQL</a>]");
                    } else if (runStatus.equals((Object)ChangeSet.RunStatus.INVALID_MD5SUM)) {
                        this.writeTD(fileWriter, "INVALID MD5SUM");
                    } else if (runStatus.equals((Object)ChangeSet.RunStatus.ALREADY_RAN)) {
                        this.writeTD(fileWriter, "Executed " + DateFormat.getDateTimeInstance(3, 3).format(this.database.getRanDate(change.getChangeSet())));
                    } else if (runStatus.equals((Object)ChangeSet.RunStatus.RUN_AGAIN)) {
                        this.writeTD(fileWriter, "Executed, WILL RUN AGAIN");
                    } else {
                        throw new RuntimeException("Unknown run status: " + (Object)((Object)runStatus));
                    }
                    fileWriter.append("</TR>");
                    if (StringUtils.trimToNull(change.getChangeSet().getComments()) != null) {
                        fileWriter.append("<TR><TD BGCOLOR='#EEEEFF' CLASS='TableSubHeadingColor' colspan='4'>").append(change.getChangeSet().getComments()).append("</TD></TR>");
                    }
                }
                fileWriter.append("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n");
                fileWriter.append("<td colspan='4'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(change.getConfirmationMessage()).append("</td></TR>");
            }
        }
        fileWriter.append("</TABLE>");
        fileWriter.append("&nbsp;</P>");
    }
}

