/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.template;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import liquibase.database.template.SqlParameter;
import liquibase.database.template.SqlTypeValue;

abstract class StatementCreatorUtils {
    StatementCreatorUtils() {
    }

    public static void setParameterValue(PreparedStatement preparedStatement, int n, SqlParameter sqlParameter, Object object) throws SQLException {
        StatementCreatorUtils.setParameterValueInternal(preparedStatement, n, sqlParameter.getSqlType(), sqlParameter.getTypeName(), sqlParameter.getScale(), object);
    }

    public static void setParameterValue(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        StatementCreatorUtils.setParameterValueInternal(preparedStatement, n, n2, null, null, object);
    }

    private static void setParameterValueInternal(PreparedStatement preparedStatement, int n, int n2, String string, Integer n3, Object object) throws SQLException {
        if (object == null) {
            if (n2 == Integer.MIN_VALUE) {
                boolean bl = false;
                try {
                    bl = preparedStatement.getConnection().getMetaData().getDatabaseProductName().indexOf("Informix") != -1;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (bl) {
                    preparedStatement.setObject(n, null);
                } else {
                    preparedStatement.setNull(n, 0);
                }
            } else if (string != null) {
                preparedStatement.setNull(n, n2, string);
            } else {
                preparedStatement.setNull(n, n2);
            }
        } else if (object instanceof SqlTypeValue) {
            ((SqlTypeValue)object).setTypeValue(preparedStatement, n, n2, string);
        } else if (n2 == 12) {
            preparedStatement.setString(n, object.toString());
        } else if (n2 == 3 || n2 == 2) {
            if (object instanceof BigDecimal) {
                preparedStatement.setBigDecimal(n, (BigDecimal)object);
            } else if (n3 != null) {
                preparedStatement.setObject(n, object, n2, (int)n3);
            } else {
                preparedStatement.setObject(n, object, n2);
            }
        } else if (n2 == 91) {
            if (object instanceof Date) {
                if (object instanceof java.sql.Date) {
                    preparedStatement.setDate(n, (java.sql.Date)object);
                } else {
                    preparedStatement.setDate(n, new java.sql.Date(((Date)object).getTime()));
                }
            } else if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                preparedStatement.setDate(n, new java.sql.Date(calendar.getTime().getTime()), calendar);
            } else {
                preparedStatement.setObject(n, object, 91);
            }
        } else if (n2 == 92) {
            if (object instanceof Date) {
                if (object instanceof Time) {
                    preparedStatement.setTime(n, (Time)object);
                } else {
                    preparedStatement.setTime(n, new Time(((Date)object).getTime()));
                }
            } else if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                preparedStatement.setTime(n, new Time(calendar.getTime().getTime()), calendar);
            } else {
                preparedStatement.setObject(n, object, 92);
            }
        } else if (n2 == 93) {
            if (object instanceof Date) {
                if (object instanceof Timestamp) {
                    preparedStatement.setTimestamp(n, (Timestamp)object);
                } else {
                    preparedStatement.setTimestamp(n, new Timestamp(((Date)object).getTime()));
                }
            } else if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                preparedStatement.setTimestamp(n, new Timestamp(calendar.getTime().getTime()), calendar);
            } else {
                preparedStatement.setObject(n, object, 93);
            }
        } else if (n2 == Integer.MIN_VALUE) {
            if (StatementCreatorUtils.isStringValue(object)) {
                preparedStatement.setString(n, object.toString());
            } else if (StatementCreatorUtils.isDateValue(object)) {
                preparedStatement.setTimestamp(n, new Timestamp(((Date)object).getTime()));
            } else if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                preparedStatement.setTimestamp(n, new Timestamp(calendar.getTime().getTime()));
            } else {
                preparedStatement.setObject(n, object);
            }
        } else {
            preparedStatement.setObject(n, object, n2);
        }
    }

    private static boolean isStringValue(Object object) {
        return object instanceof CharSequence || object instanceof StringWriter;
    }

    private static boolean isDateValue(Object object) {
        return object instanceof Date && !(object instanceof java.sql.Date) && !(object instanceof Time) && !(object instanceof Timestamp);
    }
}

