/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.template;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import liquibase.database.template.RowMapper;
import liquibase.util.JdbcUtils;
import liquibase.util.NumberUtils;

class SingleColumnRowMapper
implements RowMapper {
    private Class requiredType;

    public SingleColumnRowMapper() {
    }

    public SingleColumnRowMapper(Class clazz) {
        this.requiredType = clazz;
    }

    public void setRequiredType(Class clazz) {
        this.requiredType = clazz;
    }

    public Object mapRow(ResultSet resultSet, int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        if (n2 != 1) {
            throw new SQLException("Returned too many rows");
        }
        Object object = this.getColumnValue(resultSet, 1, this.requiredType);
        if (object != null && this.requiredType != null && !this.requiredType.isInstance(object)) {
            try {
                return this.convertValueToRequiredType(object, this.requiredType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SQLException("Type mismatch affecting row number " + n + " and column type '" + resultSetMetaData.getColumnTypeName(1) + "': " + illegalArgumentException.getMessage());
            }
        }
        return object;
    }

    protected Object getColumnValue(ResultSet resultSet, int n, Class clazz) throws SQLException {
        if (clazz != null) {
            Object object;
            boolean bl = false;
            if (String.class.equals((Object)clazz)) {
                object = resultSet.getString(n);
            } else if (Boolean.class.equals((Object)clazz)) {
                object = resultSet.getBoolean(n) ? Boolean.TRUE : Boolean.FALSE;
                bl = true;
            } else if (Byte.class.equals((Object)clazz)) {
                object = resultSet.getByte(n);
                bl = true;
            } else if (Short.class.equals((Object)clazz)) {
                object = resultSet.getShort(n);
                bl = true;
            } else if (Integer.class.equals((Object)clazz)) {
                object = resultSet.getInt(n);
                bl = true;
            } else if (Long.class.equals((Object)clazz)) {
                object = resultSet.getLong(n);
                bl = true;
            } else if (Float.class.equals((Object)clazz)) {
                object = Float.valueOf(resultSet.getFloat(n));
                bl = true;
            } else if (Double.class.equals((Object)clazz) || Number.class.equals((Object)clazz)) {
                object = resultSet.getDouble(n);
                bl = true;
            } else {
                object = byte[].class.equals((Object)clazz) ? (Object)resultSet.getBytes(n) : (Date.class.equals((Object)clazz) ? resultSet.getDate(n) : (Time.class.equals((Object)clazz) ? resultSet.getTime(n) : (Timestamp.class.equals((Object)clazz) || java.util.Date.class.equals((Object)clazz) ? resultSet.getTimestamp(n) : (BigDecimal.class.equals((Object)clazz) ? resultSet.getBigDecimal(n) : (Blob.class.equals((Object)clazz) ? resultSet.getBlob(n) : (Clob.class.equals((Object)clazz) ? resultSet.getClob(n) : resultSet.getObject(n)))))));
            }
            if (bl && object != null && resultSet.wasNull()) {
                object = null;
            }
            return object;
        }
        return this.getColumnValue(resultSet, n);
    }

    protected Object getColumnValue(ResultSet resultSet, int n) throws SQLException {
        return JdbcUtils.getResultSetValue(resultSet, n);
    }

    protected Object convertValueToRequiredType(Object object, Class clazz) {
        if (String.class.equals((Object)this.requiredType)) {
            return object.toString();
        }
        if (Number.class.isAssignableFrom(this.requiredType)) {
            if (object instanceof Number) {
                return NumberUtils.convertNumberToTargetClass((Number)object, this.requiredType);
            }
            return NumberUtils.parseNumber(object.toString(), this.requiredType);
        }
        throw new IllegalArgumentException("Value [" + object + "] is of type [" + object.getClass().getName() + "] and cannot be converted to required type [" + this.requiredType.getName() + "]");
    }
}

