/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.template;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import liquibase.database.template.ResultSetExtractor;
import liquibase.database.template.RowMapper;

class RowMapperResultSetExtractor
implements ResultSetExtractor {
    private final RowMapper rowMapper;
    private final int rowsExpected;

    public RowMapperResultSetExtractor(RowMapper rowMapper) {
        this(rowMapper, 0);
    }

    public RowMapperResultSetExtractor(RowMapper rowMapper, int n) {
        this.rowMapper = rowMapper;
        this.rowsExpected = n;
    }

    public Object extractData(ResultSet resultSet) throws SQLException {
        ArrayList<Object> arrayList = this.rowsExpected > 0 ? new ArrayList<Object>(this.rowsExpected) : new ArrayList();
        int n = 0;
        while (resultSet.next()) {
            arrayList.add(this.rowMapper.mapRow(resultSet, n++));
        }
        return arrayList;
    }
}

