/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.template;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.sql.CallableSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.template.CallableStatementCallback;
import liquibase.database.template.ColumnMapRowMapper;
import liquibase.database.template.ResultSetExtractor;
import liquibase.database.template.RowCallbackHandler;
import liquibase.database.template.RowMapper;
import liquibase.database.template.RowMapperResultSetExtractor;
import liquibase.database.template.SingleColumnRowMapper;
import liquibase.database.template.StatementCallback;
import liquibase.exception.JDBCException;
import liquibase.exception.StatementNotSupportedOnDatabaseException;
import liquibase.log.LogFactory;
import liquibase.util.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTemplate {
    protected Database database;

    public JdbcTemplate(Database database) {
        this.database = database;
    }

    public boolean executesStatements() {
        return true;
    }

    public Object execute(StatementCallback statementCallback, List<SqlVisitor> list) throws JDBCException {
        DatabaseConnection databaseConnection = this.database.getConnection();
        Statement statement = null;
        try {
            Statement statement2 = statement = databaseConnection.createStatement();
            Object object = statementCallback.doInStatement(statement2);
            return object;
        }
        catch (SQLException sQLException) {
            JdbcUtils.closeStatement(statement);
            statement = null;
            throw new JDBCException("Error executing SQL " + this.applyVisitors(statementCallback.getStatement(), list), sQLException);
        }
        finally {
            JdbcUtils.closeStatement(statement);
        }
    }

    public void execute(SqlStatement sqlStatement) throws JDBCException {
        this.execute(sqlStatement, new ArrayList<SqlVisitor>());
    }

    public void execute(final SqlStatement sqlStatement, final List<SqlVisitor> list) throws JDBCException {
        if (sqlStatement instanceof CallableSqlStatement) {
            this.call((CallableSqlStatement)sqlStatement, new ArrayList(), list);
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ExecuteStatementCallback
        implements StatementCallback {
            ExecuteStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement statement) throws SQLException, JDBCException {
                String string = JdbcTemplate.this.applyVisitors(sqlStatement, list);
                statement.execute(string);
                return null;
            }

            @Override
            public SqlStatement getStatement() {
                return sqlStatement;
            }
        }
        this.execute(new ExecuteStatementCallback(), list);
    }

    protected String applyVisitors(SqlStatement sqlStatement, List<SqlVisitor> list) throws StatementNotSupportedOnDatabaseException {
        String string = sqlStatement.getSqlStatement(this.database);
        for (SqlVisitor sqlVisitor : list) {
            if (!sqlVisitor.isApplicable(this.database)) continue;
            string = sqlVisitor.modifySql(string, this.database);
        }
        return string;
    }

    public Object query(SqlStatement sqlStatement, ResultSetExtractor resultSetExtractor) throws JDBCException {
        return this.query(sqlStatement, resultSetExtractor, new ArrayList<SqlVisitor>());
    }

    public Object query(final SqlStatement sqlStatement, final ResultSetExtractor resultSetExtractor, final List<SqlVisitor> list) throws JDBCException {
        if (sqlStatement instanceof CallableSqlStatement) {
            throw new JDBCException("Direct query using CallableSqlStatement not currently implemented");
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class QueryStatementCallback
        implements StatementCallback {
            QueryStatementCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doInStatement(Statement statement) throws SQLException, JDBCException {
                Object object;
                ResultSet resultSet = null;
                try {
                    ResultSet resultSet2 = resultSet = statement.executeQuery(JdbcTemplate.this.applyVisitors(sqlStatement, list));
                    object = resultSetExtractor.extractData(resultSet2);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(resultSet);
                    throw throwable;
                }
                JdbcUtils.closeResultSet(resultSet);
                return object;
            }

            @Override
            public SqlStatement getStatement() {
                return sqlStatement;
            }
        }
        return this.execute(new QueryStatementCallback(), list);
    }

    public List query(SqlStatement sqlStatement, RowMapper rowMapper) throws JDBCException {
        return this.query(sqlStatement, rowMapper, new ArrayList<SqlVisitor>());
    }

    public List query(SqlStatement sqlStatement, RowMapper rowMapper, List<SqlVisitor> list) throws JDBCException {
        return (List)this.query(sqlStatement, new RowMapperResultSetExtractor(rowMapper), list);
    }

    public Object queryForObject(SqlStatement sqlStatement, RowMapper rowMapper) throws JDBCException {
        return this.queryForObject(sqlStatement, rowMapper, new ArrayList<SqlVisitor>());
    }

    public Object queryForObject(SqlStatement sqlStatement, RowMapper rowMapper, List<SqlVisitor> list) throws JDBCException {
        List list2 = this.query(sqlStatement, rowMapper, list);
        return JdbcUtils.requiredSingleResult(list2);
    }

    public Object queryForObject(SqlStatement sqlStatement, Class clazz) throws JDBCException {
        return this.queryForObject(sqlStatement, clazz, new ArrayList<SqlVisitor>());
    }

    public Object queryForObject(SqlStatement sqlStatement, Class clazz, List<SqlVisitor> list) throws JDBCException {
        return this.queryForObject(sqlStatement, this.getSingleColumnRowMapper(clazz), list);
    }

    public long queryForLong(SqlStatement sqlStatement) throws JDBCException {
        return this.queryForLong(sqlStatement, new ArrayList<SqlVisitor>());
    }

    public long queryForLong(SqlStatement sqlStatement, List<SqlVisitor> list) throws JDBCException {
        Number number = (Number)this.queryForObject(sqlStatement, Long.class, list);
        return number != null ? number.longValue() : 0L;
    }

    public int queryForInt(SqlStatement sqlStatement) throws JDBCException {
        return this.queryForInt(sqlStatement, new ArrayList<SqlVisitor>());
    }

    public int queryForInt(SqlStatement sqlStatement, List<SqlVisitor> list) throws JDBCException {
        Number number = (Number)this.queryForObject(sqlStatement, Integer.class, list);
        return number != null ? number.intValue() : 0;
    }

    public List queryForList(SqlStatement sqlStatement, Class clazz) throws JDBCException {
        return this.queryForList(sqlStatement, clazz, new ArrayList<SqlVisitor>());
    }

    public List queryForList(SqlStatement sqlStatement, Class clazz, List<SqlVisitor> list) throws JDBCException {
        return this.query(sqlStatement, this.getSingleColumnRowMapper(clazz), list);
    }

    public List<Map> queryForList(SqlStatement sqlStatement) throws JDBCException {
        return this.queryForList(sqlStatement, new ArrayList<SqlVisitor>());
    }

    public List<Map> queryForList(SqlStatement sqlStatement, List<SqlVisitor> list) throws JDBCException {
        return this.query(sqlStatement, this.getColumnMapRowMapper(), list);
    }

    public int update(SqlStatement sqlStatement) throws JDBCException {
        return this.update(sqlStatement, new ArrayList<SqlVisitor>());
    }

    public int update(final SqlStatement sqlStatement, final List<SqlVisitor> list) throws JDBCException {
        if (sqlStatement instanceof CallableSqlStatement) {
            throw new JDBCException("Direct update using CallableSqlStatement not currently implemented");
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UpdateStatementCallback
        implements StatementCallback {
            UpdateStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement statement) throws SQLException, JDBCException {
                return statement.executeUpdate(JdbcTemplate.this.applyVisitors(sqlStatement, list));
            }

            @Override
            public SqlStatement getStatement() {
                return sqlStatement;
            }
        }
        return (Integer)this.execute(new UpdateStatementCallback(), list);
    }

    public Object execute(CallableSqlStatement callableSqlStatement, CallableStatementCallback callableStatementCallback, List<SqlVisitor> list) throws JDBCException {
        Object object;
        CallableStatement callableStatement = null;
        try {
            CallableStatement callableStatement2 = callableStatement = callableSqlStatement.createCallableStatement(this.database);
            object = callableStatementCallback.doInCallableStatement(callableStatement2);
        }
        catch (SQLException sQLException) {
            try {
                throw new JDBCException("Error executing callable statement", sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(callableStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(callableStatement);
        return object;
    }

    public Map call(CallableSqlStatement callableSqlStatement, List list, List<SqlVisitor> list2) throws JDBCException {
        return (Map)this.execute(callableSqlStatement, new CallableStatementCallback(){

            public Object doInCallableStatement(CallableStatement callableStatement) throws SQLException {
                callableStatement.execute();
                return new HashMap();
            }
        }, list2);
    }

    protected RowMapper getColumnMapRowMapper() {
        return new ColumnMapRowMapper();
    }

    protected RowMapper getSingleColumnRowMapper(Class clazz) {
        return new SingleColumnRowMapper(clazz);
    }

    public void comment(String string) throws JDBCException {
        LogFactory.getLogger().info(string);
    }

    private static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor {
        private final RowCallbackHandler rch;

        public RowCallbackHandlerResultSetExtractor(RowCallbackHandler rowCallbackHandler) {
            this.rch = rowCallbackHandler;
        }

        public Object extractData(ResultSet resultSet) throws SQLException {
            while (resultSet.next()) {
                this.rch.processRow(resultSet);
            }
            return null;
        }
    }
}

