/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.template;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.MSSQLDatabase;
import liquibase.database.sql.CallableSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.template.CallableStatementCallback;
import liquibase.database.template.JdbcTemplate;
import liquibase.database.template.StatementCallback;
import liquibase.exception.JDBCException;
import liquibase.util.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcOutputTemplate
extends JdbcTemplate {
    private Writer output;
    private boolean alreadyCreatedChangeLockTable;
    private boolean alreadyCreatedChangeTable;

    public JdbcOutputTemplate(Writer writer, Database database) {
        super(database);
        this.output = writer;
    }

    @Override
    public boolean executesStatements() {
        return false;
    }

    @Override
    public void execute(SqlStatement sqlStatement) throws JDBCException {
        this.outputStatement(sqlStatement);
    }

    @Override
    public int update(SqlStatement sqlStatement) throws JDBCException {
        this.outputStatement(sqlStatement);
        return 0;
    }

    @Override
    public Object execute(StatementCallback statementCallback, List<SqlVisitor> list) throws JDBCException {
        this.outputStatement(statementCallback.getStatement(), list);
        return null;
    }

    @Override
    public void execute(SqlStatement sqlStatement, List<SqlVisitor> list) throws JDBCException {
        this.outputStatement(sqlStatement, list);
    }

    @Override
    public int update(SqlStatement sqlStatement, List<SqlVisitor> list) throws JDBCException {
        this.outputStatement(sqlStatement, list);
        return 0;
    }

    @Override
    public Object execute(CallableSqlStatement callableSqlStatement, CallableStatementCallback callableStatementCallback, List<SqlVisitor> list) throws JDBCException {
        throw new JDBCException("Do not know how to output callable statement");
    }

    @Override
    public Map call(CallableSqlStatement callableSqlStatement, List list, List<SqlVisitor> list2) throws JDBCException {
        throw new JDBCException("Do not know how to output callable statement");
    }

    @Override
    public void comment(String string) throws JDBCException {
        try {
            this.output.write(this.database.getLineComment());
            this.output.write(" ");
            this.output.write(string);
            this.output.write(StreamUtil.getLineSeparator());
        }
        catch (IOException iOException) {
            throw new JDBCException(iOException);
        }
    }

    private void outputStatement(SqlStatement sqlStatement) throws JDBCException {
    }

    private void outputStatement(SqlStatement sqlStatement, List<SqlVisitor> list) throws JDBCException {
        try {
            String string = this.applyVisitors(sqlStatement, list);
            this.output.write(string);
            if (!string.endsWith(";")) {
                this.output.write(";");
            }
            if (this.database instanceof MSSQLDatabase) {
                this.output.write(StreamUtil.getLineSeparator());
                this.output.write("GO");
            }
            this.output.write(StreamUtil.getLineSeparator());
            this.output.write(StreamUtil.getLineSeparator());
        }
        catch (IOException iOException) {
            throw new JDBCException(iOException);
        }
    }

    public boolean alreadyCreatedChangeLockTable() {
        return this.alreadyCreatedChangeLockTable;
    }

    public void setAlreadyCreatedChangeLockTable(boolean bl) {
        this.alreadyCreatedChangeLockTable = bl;
    }

    public boolean alreadyCreatedChangeTable() {
        return this.alreadyCreatedChangeTable;
    }

    public void setAlreadyCreatedChangeTable(boolean bl) {
        this.alreadyCreatedChangeTable = bl;
    }
}

