/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.template;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import liquibase.database.template.RowMapper;
import liquibase.util.JdbcUtils;

class ColumnMapRowMapper
implements RowMapper {
    ColumnMapRowMapper() {
    }

    public Object mapRow(ResultSet resultSet, int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        Map map = this.createColumnMap(n2);
        for (int i = 1; i <= n2; ++i) {
            String string = this.getColumnKey(resultSetMetaData.getColumnName(i));
            Object object = this.getColumnValue(resultSet, i);
            map.put(string, object);
        }
        return map;
    }

    protected Map createColumnMap(int n) {
        return new LinkedHashMap(n);
    }

    protected String getColumnKey(String string) {
        return string;
    }

    protected Object getColumnValue(ResultSet resultSet, int n) throws SQLException {
        return JdbcUtils.getResultSetValue(resultSet, n);
    }
}

