/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.template;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import liquibase.database.template.PreparedStatementSetter;
import liquibase.database.template.StatementCreatorUtils;
import liquibase.exception.JDBCException;

class ArgTypePreparedStatementSetter
implements PreparedStatementSetter {
    private final Object[] args;
    private final int[] argTypes;

    public ArgTypePreparedStatementSetter(Object[] objectArray, int[] nArray) throws JDBCException {
        if (objectArray != null && nArray == null || objectArray == null && nArray != null || objectArray != null && objectArray.length != nArray.length) {
            throw new JDBCException("args and argTypes parameters must match");
        }
        this.args = objectArray;
        this.argTypes = nArray;
    }

    public void setValues(PreparedStatement preparedStatement) throws SQLException {
        int n = 1;
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                Object object = this.args[i];
                if (object instanceof Collection && this.argTypes[i] != 2003) {
                    Collection collection = (Collection)object;
                    for (Object e : collection) {
                        StatementCreatorUtils.setParameterValue(preparedStatement, n++, this.argTypes[i], e);
                    }
                    continue;
                }
                StatementCreatorUtils.setParameterValue(preparedStatement, n++, this.argTypes[i], object);
            }
        }
    }
}

